/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RoundRobinPartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ReplicationPartitioningMetadata;

public class RoundRobinPartitioningMetadata
extends ReplicationPartitioningMetadata {
    protected Boolean replicateWrites;

    public RoundRobinPartitioningMetadata() {
        super("<round-robin-partitioning>");
    }

    public RoundRobinPartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.replicateWrites = (Boolean)annotation.getAttribute("replicateWrites");
    }

    public PartitioningPolicy buildPolicy() {
        RoundRobinPartitioningPolicy policy = new RoundRobinPartitioningPolicy();
        super.buildPolicy((PartitioningPolicy)policy);
        if (this.replicateWrites != null) {
            policy.setReplicateWrites(this.replicateWrites.booleanValue());
        }
        return policy;
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RoundRobinPartitioningMetadata) {
            RoundRobinPartitioningMetadata policy = (RoundRobinPartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.replicateWrites, policy.getReplicateWrites());
        }
        return false;
    }

    public Boolean getReplicateWrites() {
        return this.replicateWrites;
    }

    public void setReplicateWrites(Boolean replicateWrites) {
        this.replicateWrites = replicateWrites;
    }
}

