/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;

public class NamedQueryHandler
extends QueryHandler {
    protected String name;
    protected String descriptor;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public void validate(XRServiceAdapter xrService, QueryOperation queryOperation) {
        if (this.descriptor != null) {
            if (!xrService.getORSession().getProject().getAliasDescriptors().containsKey(this.descriptor)) {
                throw DBWSException.couldNotLocateDescriptorForOperation((String)this.descriptor, (String)this.getName());
            }
            ClassDescriptor cd = xrService.getORSession().getProject().getDescriptorForAlias(this.descriptor);
            if (cd.getQueryManager().getQuery(this.name) == null) {
                throw DBWSException.couldNotLocateQueryForDescriptor((String)this.name, (String)this.descriptor);
            }
        } else if (xrService.getORSession().getQuery(this.name) == null) {
            throw DBWSException.couldNotLocateQueryForSession((String)this.name, (String)xrService.getORSession().getName());
        }
    }

    public void initialize(XRServiceAdapter xrService, QueryOperation queryOperation) {
        if (this.descriptor != null) {
            ClassDescriptor cd = xrService.getORSession().getProject().getDescriptorForAlias(this.descriptor);
            this.databaseQuery = cd.getQueryManager().getQuery(this.name);
        } else {
            this.databaseQuery = xrService.getORSession().getQuery(this.name);
        }
    }
}

