/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableVariableDeclaration
extends AbstractExpression {
    private String asIdentifier;
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterTableExpression;
    private AbstractExpression identificationVariable;
    private TableExpression tableExpression;

    public TableVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getTableExpression().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getTableExpression());
        children.add(this.getIdentificationVariable());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.tableExpression);
        if (this.hasSpaceAfterTableExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.tableExpression != null && this.tableExpression.isAncestor(expression)) {
            return this.getQueryBNF("table_expression");
        }
        if (this.identificationVariable != null && this.identificationVariable.isAncestor(expression)) {
            return this.getQueryBNF("identification_variable");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("table_declaration");
    }

    public TableExpression getTableExpression() {
        return this.tableExpression;
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterTableExpression() {
        return this.hasSpaceAfterTableExpression;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("AS") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.tableExpression = new TableExpression(this);
        this.tableExpression.parse(wordParser, tolerant);
        this.hasSpaceAfterTableExpression = wordParser.skipLeadingWhitespace() > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            this.asIdentifier = wordParser.moveForward("AS");
            boolean bl = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.identificationVariable = this.parse(wordParser, "identification_variable", tolerant);
        } else {
            this.identificationVariable = new IdentificationVariable(this, wordParser.word());
            this.identificationVariable.parse(wordParser, tolerant);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        this.tableExpression.toParsedText(writer, actual);
        if (this.hasSpaceAfterTableExpression) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null) {
            this.identificationVariable.toParsedText(writer, actual);
        }
    }
}

