/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWSecondaryTableHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorMultiTableInfoPolicy
extends MWAbstractDescriptorPolicy {
    private Collection secondaryTableHolders;
    public static final String SECONDARY_TABLE_HOLDERS_COLLECTION = "secondaryTableHolders";

    private MWDescriptorMultiTableInfoPolicy() {
    }

    public MWDescriptorMultiTableInfoPolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.secondaryTableHolders = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.secondaryTableHolders;
        synchronized (collection) {
            children.addAll(this.secondaryTableHolders);
        }
    }

    public MWSecondaryTableHolder addSecondaryTable(MWTable secondaryTable) {
        MWSecondaryTableHolder associationHolder = new MWSecondaryTableHolder(this, secondaryTable);
        this.addItemToCollection(associationHolder, this.secondaryTableHolders, SECONDARY_TABLE_HOLDERS_COLLECTION);
        return associationHolder;
    }

    public void removeSecondaryTable(MWTable table) {
        Iterator stream = this.secondaryTableHolders();
        while (stream.hasNext()) {
            MWSecondaryTableHolder tableAssociationHolder = (MWSecondaryTableHolder)stream.next();
            if (tableAssociationHolder.getTable() != table) continue;
            this.removeSecondaryTableHolder(tableAssociationHolder);
            return;
        }
    }

    void removeSecondaryTableHolder(MWSecondaryTableHolder holder) {
        this.removeItemFromCollection(holder, this.secondaryTableHolders, SECONDARY_TABLE_HOLDERS_COLLECTION);
    }

    public MWSecondaryTableHolder secondaryTableHolderFor(MWTable table) {
        Iterator stream = this.secondaryTableHolders();
        while (stream.hasNext()) {
            MWSecondaryTableHolder tableHolder = (MWSecondaryTableHolder)stream.next();
            if (tableHolder.getTable() != table) continue;
            return tableHolder;
        }
        return null;
    }

    public Iterator secondaryTableHolders() {
        return new CloneIterator(this.secondaryTableHolders);
    }

    private MWReference secondaryReferenceFor(MWTable table) {
        Iterator stream = this.secondaryReferences();
        while (stream.hasNext()) {
            MWReference reference = (MWReference)stream.next();
            if (reference.getSourceTable() != table && reference.getTargetTable() != table) continue;
            return reference;
        }
        return null;
    }

    private Iterator secondaryReferences() {
        ArrayList<MWReference> references = new ArrayList<MWReference>();
        Iterator stream = this.secondaryTableHolders();
        while (stream.hasNext()) {
            MWSecondaryTableHolder holder = (MWSecondaryTableHolder)stream.next();
            if (holder.primaryKeysHaveSameName() || holder.getReference() == null) continue;
            references.add(holder.getReference());
        }
        return references.iterator();
    }

    public int secondaryTableHoldersSize() {
        return this.secondaryTableHolders.size();
    }

    public Iterator secondaryTables() {
        return new TransformationIterator(this.secondaryTableHolders()){

            @Override
            protected Object transform(Object next) {
                return ((MWSecondaryTableHolder)next).getTable();
            }
        };
    }

    private MWTableDescriptor getTableDescriptor() {
        return (MWTableDescriptor)this.getOwningDescriptor();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    @Override
    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkPrimaryKeysAcrossMultipleTables(problems);
    }

    private void checkPrimaryKeysAcrossMultipleTables(List newProblems) {
        if (!this.pksAcrossMultipleTablesTest(false)) {
            newProblems.add(this.buildProblem("0319"));
        }
    }

    public boolean pksAcrossMultipleTablesTest(boolean moreThanOneTableMustBeDefined) {
        int associatedTablesSize = this.getTableDescriptor().associatedTablesSize();
        if (associatedTablesSize < 2) {
            return !moreThanOneTableMustBeDefined;
        }
        MWTable primaryTable = this.getTableDescriptor().getPrimaryTable();
        if (primaryTable == null) {
            return false;
        }
        Iterator tables = this.getTableDescriptor().associatedTables();
        while (tables.hasNext()) {
            MWTable secondaryTable = (MWTable)tables.next();
            MWSecondaryTableHolder tableAssociationHolder = this.secondaryTableHolderFor(secondaryTable);
            if (tableAssociationHolder == null || !tableAssociationHolder.primaryKeysHaveSameName()) continue;
            Iterator columns = primaryTable.primaryKeyColumns();
            while (columns.hasNext()) {
                MWColumn pk = (MWColumn)columns.next();
                MWColumn matchingPk = secondaryTable.columnNamed(pk.getName());
                if (matchingPk != null && matchingPk.isPrimaryKey()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        runtimeDescriptor.getAdditionalTablePrimaryKeyFields();
        Iterator secondaryTables = this.getTableDescriptor().secondaryTables();
        while (secondaryTables.hasNext()) {
            MWTable secondaryTable = (MWTable)secondaryTables.next();
            ((RelationalDescriptor)runtimeDescriptor).addTableName(secondaryTable.getName());
        }
        Iterator tableAssocs = this.secondaryReferences();
        while (tableAssocs.hasNext()) {
            MWReference ref = (MWReference)tableAssocs.next();
            Iterator stream = ref.columnPairs();
            while (stream.hasNext()) {
                MWColumnPair columnPair = (MWColumnPair)stream.next();
                if (columnPair.getSourceColumn() == null || columnPair.getTargetColumn() == null) continue;
                String sourceColumnName = columnPair.getSourceColumn().qualifiedName();
                String targetColumnName = columnPair.getTargetColumn().qualifiedName();
                runtimeDescriptor.addForeignKeyFieldNameForMultipleTable(sourceColumnName, targetColumnName);
            }
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorMultiTableInfoPolicy.class);
        XMLCompositeCollectionMapping secondaryTableAssociationHoldersMapping = new XMLCompositeCollectionMapping();
        secondaryTableAssociationHoldersMapping.setAttributeName(SECONDARY_TABLE_HOLDERS_COLLECTION);
        secondaryTableAssociationHoldersMapping.setReferenceClass(MWSecondaryTableHolder.class);
        secondaryTableAssociationHoldersMapping.setXPath("secondary-table-holders/table-holder");
        descriptor.addMapping((DatabaseMapping)secondaryTableAssociationHoldersMapping);
        return descriptor;
    }
}

