/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;

public final class MWRelationalClassIndicatorFieldPolicy
extends MWClassIndicatorFieldPolicy
implements AggregateRuntimeFieldNameGenerator {
    private MWColumnHandle columnHandle;
    public static final String FIELD_PROPERTY = "field";
    private static final PartialStringMatcher COLUMN_NAME_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    private MWRelationalClassIndicatorFieldPolicy() {
    }

    public MWRelationalClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent) {
        this(parent, NullIterator.instance());
    }

    public MWRelationalClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent, Iterator descriptorsAvailableForIndication) {
        super(parent);
        this.setDescriptorsAvailableForIndicatorDictionary(descriptorsAvailableForIndication);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalClassIndicatorFieldPolicy.this.setColumn(null);
            }

            public String toString() {
                return "MWRelationalClassIndicatorFieldPolicy.buildColumnScrubber()";
            }
        };
    }

    @Override
    public MWDataField getField() {
        return this.getColumn();
    }

    public void setField(MWDataField field) {
        this.setColumn((MWColumn)field);
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn column) {
        MWColumn old = this.columnHandle.getColumn();
        this.columnHandle.setColumn(column);
        this.firePropertyChanged(FIELD_PROPERTY, old, column);
    }

    @Override
    protected boolean fieldSpecified() {
        return ((MWRelationalDescriptor)((Object)this.getContainingDescriptor())).isAggregateDescriptor() || this.getField() != null;
    }

    @Override
    public String fieldNameForRuntime() {
        return "CLASS_INDICATOR_FIELD";
    }

    @Override
    public AggregateFieldDescription fullFieldDescription() {
        return new AggregateFieldDescription(){

            @Override
            public String getMessageKey() {
                if (MWRelationalClassIndicatorFieldPolicy.this.getParent() instanceof MWDescriptorInheritancePolicy) {
                    return "AGGREGATE_FIELD_DESCRIPTION_FOR_CLASS_INDICATOR_FIELD_FOR_INHERITANCE";
                }
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_CLASS_INDICATOR_FIELD";
            }

            @Override
            public Object[] getMessageArguments() {
                return new Object[0];
            }
        };
    }

    @Override
    public void parentDescriptorMorphedToAggregate() {
        this.setField(null);
    }

    @Override
    public boolean fieldIsWritten() {
        return true;
    }

    @Override
    public MWDescriptor owningDescriptor() {
        return this.getContainingDescriptor();
    }

    @Override
    public void addToAggregateFieldNameGenerators(Collection generators) {
        generators.add(this);
    }

    @Override
    public void automap() {
        super.automap();
        this.automapColumn();
    }

    private void automapColumn() {
        double score2;
        MWRelationalDescriptor descriptor = (MWRelationalDescriptor)((Object)this.getContainingDescriptor());
        if (!descriptor.isAggregateDescriptor()) {
            return;
        }
        ColumnStringHolder[] columnStringHolders = this.allUnmappedColumnStringHolders((MWTableDescriptor)descriptor);
        if (columnStringHolders.length == 0) {
            return;
        }
        PartialStringMatcher.StringHolderScore shs1 = this.match("type", columnStringHolders);
        PartialStringMatcher.StringHolderScore shs2 = this.match("class", columnStringHolders);
        MWColumn column1 = ((ColumnStringHolder)shs1.getStringHolder()).getColumn();
        MWColumn column2 = ((ColumnStringHolder)shs2.getStringHolder()).getColumn();
        double score1 = shs1.getScore();
        if (Math.max(score1, score2 = shs2.getScore()) > 0.5) {
            this.setField(score1 >= score2 ? column1 : column2);
        }
    }

    private ColumnStringHolder[] allUnmappedColumnStringHolders(MWTableDescriptor descriptor) {
        HashSet unmappedColumns = new HashSet();
        Iterator stream = descriptor.associatedTables();
        while (stream.hasNext()) {
            CollectionTools.addAll(unmappedColumns, ((MWTable)stream.next()).columns());
        }
        HashSet mappedColumns = new HashSet();
        Iterator mappings = descriptor.mappings();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            mapping.addWrittenFieldsTo(mappedColumns);
        }
        unmappedColumns.removeAll(mappedColumns);
        return ColumnStringHolder.buildHolders(unmappedColumns);
    }

    private PartialStringMatcher.StringHolderScore match(String string, ColumnStringHolder[] columnStringHolders) {
        return COLUMN_NAME_MATCHER.match(string, columnStringHolders);
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.addClassIndicatorFieldNotSpecifiedProblemTo(newProblems);
    }

    public void addClassIndicatorFieldNotSpecifiedProblemTo(List newProblems) {
        ((Parent)((Object)this.getParent())).addClassIndicatorFieldNotSpecifiedProblemTo(newProblems);
    }

    @Override
    public void adjustRuntimeInheritancePolicy(InheritancePolicy runtimeInheritancePolicy) {
        super.adjustRuntimeInheritancePolicy(runtimeInheritancePolicy);
        if (this.getColumn() != null) {
            runtimeInheritancePolicy.setClassIndicatorFieldName(this.getColumn().qualifiedName());
        } else {
            runtimeInheritancePolicy.setClassIndicatorFieldName(this.fieldNameForRuntime());
        }
    }

    public void adjustRuntimeMapping(VariableOneToOneMapping runtimeMapping) {
        String classIndicatorFieldName = null;
        if (this.getField() != null) {
            classIndicatorFieldName = this.getColumn().qualifiedName();
        } else if (((MWVariableOneToOneMapping)this.getParent()).parentDescriptorIsAggregate()) {
            classIndicatorFieldName = runtimeMapping.getAttributeName() + "->" + this.fieldNameForRuntime();
        }
        if (classIndicatorFieldName != null && !classIndicatorFieldName.equals("")) {
            runtimeMapping.setTypeFieldName(classIndicatorFieldName);
            Iterator indicatorValues = this.includedClassIndicatorValues();
            while (indicatorValues.hasNext()) {
                Object value = ((MWClassIndicatorValue)indicatorValues.next()).getIndicatorValue();
                runtimeMapping.addClassNameIndicator(this.getDescriptorForIndicator(value).getMWClass().getName(), value);
            }
        } else {
            runtimeMapping.setTypeFieldName("");
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalClassIndicatorFieldPolicy.class);
        descriptor.getInheritancePolicy().setParentClass(MWClassIndicatorFieldPolicy.class);
        XMLCompositeObjectMapping columnHandleMapping = new XMLCompositeObjectMapping();
        columnHandleMapping.setAttributeName("columnHandle");
        columnHandleMapping.setGetMethodName("getColumnHandleForTopLink");
        columnHandleMapping.setSetMethodName("setColumnHandleForTopLink");
        columnHandleMapping.setReferenceClass(MWColumnHandle.class);
        columnHandleMapping.setXPath("column-handle");
        descriptor.addMapping((DatabaseMapping)columnHandleMapping);
        return descriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildColumnScrubber();
        this.columnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    public static interface Parent {
        public void addClassIndicatorFieldNotSpecifiedProblemTo(List var1);
    }
}

