/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.codegen.AttributeDefinition;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.MethodDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifier;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.NullChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TreeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWClass
extends MWModel
implements ClassDescription,
MWModifiable,
MWNominative {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWClassHandle declaringTypeHandle;
    public static final String DECLARING_TYPE_PROPERTY = "declaringType";
    private MWModifier modifier;
    private volatile boolean interfaceFlag;
    public static final String INTERFACE_PROPERTY = "interface";
    private MWClassHandle superclassHandle;
    public static final String SUPERCLASS_PROPERTY = "superclass";
    public static final String SUPERCLASSES_COLLECTION = "superclasses";
    private volatile Date lastRefreshTimestamp;
    public static final String LAST_REFRESH_TIMESTAMP_PROPERTY = "lastRefreshTimestamp";
    private Collection interfaceHandles;
    public static final String INTERFACES_COLLECTION = "interfaces";
    private MWHandle.NodeReferenceScrubber interfaceScrubber;
    private Collection attributes;
    public static final String ATTRIBUTES_COLLECTION = "attributes";
    private Collection ejb20Attributes;
    public static final String EJB20_ATTRIBUTES_COLLECTION = "ejb20Attributes";
    private volatile MWClassAttribute unknownPrimaryKeyAttribute;
    public static final String UNKNOWN_PK_ATTRIBUTE_PROPERTY = "unknownPKAttribute";
    private Collection methods;
    public static final String METHODS_COLLECTION = "methods";
    private Collection typeHandles;
    public static final String TYPES_COLLECTION = "types";
    private MWHandle.NodeReferenceScrubber typeScrubber;
    private volatile boolean primitive;
    private boolean coreType;
    private volatile boolean partiallyPopulatedCoreType;
    private volatile boolean coreTypeRefreshInProgress;
    private static PrimitiveWrapperPair[] primitiveWrapperPairs;
    private static PrimitiveWrapperPair voidPrimitiveWrapperPair;
    public static final String LEGACY_50_STUB_ATTRIBUTE_NAME = "stub";
    public static final Boolean LEGACY_50_STUB_NULL_VALUE;
    private static final int ALLOWED_MODIFIERS_FLAGS = 1040;
    private static final int METHOD_ALLOWED_MODIFIERS_FLAGS = 3088;

    private MWClass() {
    }

    MWClass(MWClassRepository repository, String name, boolean coreType) {
        super(repository);
        this.name = name;
        this.coreType = coreType;
        this.partiallyPopulatedCoreType = coreType;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.modifier = new MWModifier(this);
        this.partiallyPopulatedCoreType = false;
        this.coreTypeRefreshInProgress = false;
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.declaringTypeHandle = new MWClassHandle(this, this.defaultDeclaringType(), this.buildDeclaringTypeScrubber());
        this.interfaceFlag = this.defaultInterfaceFlag();
        this.lastRefreshTimestamp = null;
        this.interfaceHandles = new Vector();
        this.attributes = new Vector();
        this.ejb20Attributes = new Vector();
        this.unknownPrimaryKeyAttribute = null;
        this.methods = new Vector();
        this.typeHandles = new Vector();
    }

    void initializeNameDependentState() {
        this.primitive = this.defaultPrimitiveFlag();
        this.superclassHandle = new MWClassHandle(this, this.buildSuperclassScrubber());
        this.superclassHandle.setType(this.defaultSuperclass());
    }

    private MWClass defaultDeclaringType() {
        return null;
    }

    private boolean defaultInterfaceFlag() {
        return false;
    }

    private boolean defaultPrimitiveFlag() {
        return CollectionTools.contains(MWClass.primitiveClassNames(), (Object)this.getName());
    }

    private MWClass defaultSuperclass() {
        if (this.requiresSuperclass()) {
            return this.objectType();
        }
        return null;
    }

    public void clear() {
        if (this.isCoreType()) {
            throw new IllegalStateException();
        }
        this.setDeclaringType(this.defaultDeclaringType());
        this.getModifier().clear();
        this.setInterface(this.defaultInterfaceFlag());
        this.setSuperclass(this.defaultSuperclass());
        this.clearInterfaces();
        this.clearAttributes();
        this.clearEjb20Attributes();
        this.clearMethods();
        this.clearTypes();
    }

    @Override
    public ChangeNotifier getChangeNotifier() {
        return this.coreTypeRefreshInProgress ? NullChangeNotifier.instance() : super.getChangeNotifier();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String old = this.name;
        this.name = name;
        if (this.attributeValueHasChanged(old, name)) {
            try {
                this.getRepository().typeRenamed(old, name);
            }
            catch (RuntimeException ex) {
                this.name = old;
                throw ex;
            }
            this.firePropertyChanged(NAME_PROPERTY, old, name);
            this.getProject().nodeRenamed(this);
        }
    }

    public String fullName() {
        return this.getName();
    }

    public String shortName() {
        return ClassTools.shortNameForClassNamed(this.getName());
    }

    public String packageName() {
        return ClassTools.packageNameForClassNamed(this.getName());
    }

    public String packageDisplayName() {
        return MWClass.packageDisplayNameForClassNamed(this.getName());
    }

    public MWClass getDeclaringType() {
        return this.declaringTypeHandle.getType();
    }

    public void setDeclaringType(MWClass declaringType) {
        MWClass old = this.declaringTypeHandle.getType();
        this.declaringTypeHandle.setType(declaringType);
        this.firePropertyChanged(DECLARING_TYPE_PROPERTY, old, declaringType);
    }

    @Override
    public MWModifier getModifier() {
        return this.modifier;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isInterface() {
        return this.interfaceFlag;
    }

    public void setInterface(boolean interfaceFlag) {
        if (this.isNonReferenceType() && interfaceFlag) {
            throw new IllegalStateException("A primitive cannot be converted to an interface: " + this.getName());
        }
        boolean old = this.interfaceFlag;
        this.interfaceFlag = interfaceFlag;
        if (old != interfaceFlag) {
            this.setSuperclass(this.defaultSuperclass());
        }
        this.firePropertyChanged(INTERFACE_PROPERTY, old, interfaceFlag);
        if (old != interfaceFlag) {
            this.notifyMethodsOfAllowedModifiersChange();
        }
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public MWClass getSuperclass() {
        return this.superclassHandle.getType();
    }

    public void setSuperclass(MWClass superclass) {
        if (this.requiresSuperclass() && superclass == null) {
            throw new IllegalStateException("Superclass required: " + this);
        }
        if (this.cannotHaveSuperclass() && superclass != null) {
            throw new IllegalStateException("Superclass not allowed: " + this);
        }
        MWClass old = this.superclassHandle.getType();
        this.superclassHandle.setType(superclass);
        this.firePropertyChanged(SUPERCLASS_PROPERTY, old, superclass);
        if (old != superclass && !this.isCoreType()) {
            this.superclassesChanged();
            this.getRepository().hierarchyChanged(this);
            this.getProject().hierarchyChanged(this);
        }
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    private void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        Date old = this.lastRefreshTimestamp;
        this.lastRefreshTimestamp = lastRefreshTimestamp;
        this.firePropertyChanged(LAST_REFRESH_TIMESTAMP_PROPERTY, old, lastRefreshTimestamp);
    }

    private Date getLastRefreshTimestampForTopLink() {
        Date value = null;
        if (this.getRepository().isPersistLastRefresh()) {
            value = this.lastRefreshTimestamp;
        }
        return value;
    }

    private void setLastRefreshTimestampForTopLink(Date value) {
        this.lastRefreshTimestamp = value;
    }

    boolean isCoreType() {
        return this.coreType;
    }

    private Iterator interfaceHandles() {
        return new CloneIterator(this.interfaceHandles){

            @Override
            protected void remove(Object current) {
                MWClass.this.removeInterfaceHandle((MWClassHandle)current);
            }

            @Override
            public String toString() {
                return "MWClass.interfaceHandles()";
            }
        };
    }

    void removeInterfaceHandle(MWClassHandle handle) {
        this.interfaceHandles.remove(handle);
        this.fireItemRemoved(INTERFACES_COLLECTION, handle.getType());
    }

    public Iterator interfaces() {
        return new TransformationIterator(this.interfaceHandles()){

            @Override
            protected Object transform(Object next) {
                return ((MWClassHandle)next).getType();
            }

            @Override
            public String toString() {
                return "MWClass.interfaces()";
            }
        };
    }

    public int interfacesSize() {
        return this.interfaceHandles.size();
    }

    public void addInterface(MWClass type) {
        this.interfaceHandles.add(new MWClassHandle(this, type, this.interfaceScrubber()));
        this.fireItemAdded(INTERFACES_COLLECTION, type);
    }

    public void addInterfaces(Collection interfaces) {
        this.addInterfaces(interfaces.iterator());
    }

    public void addInterfaces(Iterator interfaces) {
        while (interfaces.hasNext()) {
            this.addInterface((MWClass)interfaces.next());
        }
    }

    public void removeInterface(MWClass type) {
        Iterator stream = this.interfaces();
        while (stream.hasNext()) {
            if (stream.next() != type) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(type.toString());
    }

    public void removeInterfaces(Collection interfaces) {
        this.removeInterfaces(interfaces.iterator());
    }

    public void removeInterfaces(Iterator interfaces) {
        while (interfaces.hasNext()) {
            this.removeInterface((MWClass)interfaces.next());
        }
    }

    public void clearInterfaces() {
        Iterator stream = this.interfaceHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    public Iterator attributes() {
        this.checkForPartiallyPopulatedCoreType();
        return new CloneIterator(this.attributes){

            @Override
            protected void remove(Object current) {
                MWClass.this.removeAttribute((MWClassAttribute)current);
            }

            @Override
            public String toString() {
                return "MWClass.attributes()";
            }
        };
    }

    public int attributesSize() {
        this.checkForPartiallyPopulatedCoreType();
        return this.attributes.size();
    }

    public MWClassAttribute addAttribute(String attributeName) {
        return this.addAttribute(attributeName, this.objectType());
    }

    public MWClassAttribute addAttribute(String attributeName, MWClass attributeType) {
        return this.addAttribute(attributeName, attributeType, 0);
    }

    public MWClassAttribute addAttribute(String attributeName, MWClass attributeType, int attributeDimensionality) {
        return this.addAttribute(this.buildAttribute(attributeName, attributeType, attributeDimensionality));
    }

    MWClassAttribute addAttribute(ExternalField externalField) {
        return this.addAttribute(new MWClassAttribute(this, externalField));
    }

    private MWClassAttribute addAttribute(MWClassAttribute attribute) {
        this.checkForPartiallyPopulatedCoreType();
        MWClassAttribute ejb20Attribute = this.ejb20AttributeNamed(attribute.getName());
        if (ejb20Attribute != null) {
            this.removeEjb20Attribute(ejb20Attribute);
        }
        this.addItemToCollection(attribute, this.attributes, ATTRIBUTES_COLLECTION);
        return attribute;
    }

    public void removeAttribute(MWClassAttribute attribute) {
        this.checkForPartiallyPopulatedCoreType();
        this.removeNodeFromCollection(attribute, this.attributes, ATTRIBUTES_COLLECTION);
    }

    public void removeAttributes(Collection attrs) {
        this.removeAttributes(attrs.iterator());
    }

    public void removeAttributes(Iterator attrs) {
        while (attrs.hasNext()) {
            this.removeAttribute((MWClassAttribute)attrs.next());
        }
    }

    public void clearAttributes() {
        this.removeAttributes(this.attributes());
    }

    public Iterator ejb20Attributes() {
        return new CloneIterator(this.ejb20Attributes){

            @Override
            protected void remove(Object current) {
                MWClass.this.removeEjb20Attribute((MWClassAttribute)current);
            }

            @Override
            public String toString() {
                return "MWClass.ejb20Attributes()";
            }
        };
    }

    public Iterator nonEjb20Attributes() {
        return this.attributes();
    }

    public int ejb20AttributesSize() {
        return this.ejb20Attributes.size();
    }

    public MWClassAttribute addEjb20Attribute(String attributeName, MWClass attributeType) {
        return this.addEjb20Attribute(attributeName, attributeType, 0);
    }

    public MWClassAttribute addEjb20Attribute(String attributeName, MWClass attributeType, int attributeDimensionality) {
        MWClassAttribute ejbAttribute = this.addEjb20Attribute(this.buildEjb20Attribute(attributeName, attributeType, attributeDimensionality));
        ejbAttribute.generateGetAndSetMethods();
        return ejbAttribute;
    }

    private MWClassAttribute addEjb20AttributeInternal(String attributeName, MWClass attributeType, int attributeDimensionality) {
        return this.addEjb20Attribute(this.buildEjb20Attribute(attributeName, attributeType, attributeDimensionality));
    }

    private MWClassAttribute addEjb20Attribute(MWClassAttribute attribute) {
        if (this.attributeNamed(attribute.getName()) != null) {
            return null;
        }
        this.addItemToCollection(attribute, this.ejb20Attributes, EJB20_ATTRIBUTES_COLLECTION);
        return attribute;
    }

    public void removeEjb20Attribute(MWClassAttribute attribute) {
        this.removeNodeFromCollection(attribute, this.ejb20Attributes, EJB20_ATTRIBUTES_COLLECTION);
    }

    public void removeEjb20Attributes(Collection attrs) {
        this.removeEjb20Attributes(attrs.iterator());
    }

    public void removeEjb20Attributes(Iterator attrs) {
        while (attrs.hasNext()) {
            this.removeEjb20Attribute((MWClassAttribute)attrs.next());
        }
    }

    public void clearEjb20Attributes() {
        this.removeEjb20Attributes(this.ejb20Attributes());
    }

    public boolean usesUnknownPrimaryKeyAttribute() {
        return this.unknownPrimaryKeyAttribute != null;
    }

    public MWClassAttribute getUnknownPrimaryKeyAttribute() {
        return this.unknownPrimaryKeyAttribute;
    }

    public Iterator methods() {
        this.checkForPartiallyPopulatedCoreType();
        return new CloneIterator(this.methods){

            @Override
            protected void remove(Object current) {
                MWClass.this.removeMethod((MWMethod)current);
            }

            @Override
            public String toString() {
                return "MWClass.methods()";
            }
        };
    }

    public int methodsSize() {
        this.checkForPartiallyPopulatedCoreType();
        return this.methods.size();
    }

    public MWMethod addMethod(String methodName) {
        return this.addMethod(this.buildMethod(methodName));
    }

    public MWMethod addMethod(String methodName, MWClass returnType) {
        return this.addMethod(this.buildMethod(methodName, returnType));
    }

    public MWMethod addMethod(String methodName, MWClass returnType, int dimensionality) {
        return this.addMethod(this.buildMethod(methodName, returnType, dimensionality));
    }

    private MWMethod addMethod(MWMethod method) {
        this.checkForPartiallyPopulatedCoreType();
        this.methods.add(method);
        this.fireItemAdded(METHODS_COLLECTION, method);
        return method;
    }

    public void removeMethod(MWMethod method) {
        this.checkForPartiallyPopulatedCoreType();
        this.removeNodeFromCollection(method, this.methods, METHODS_COLLECTION);
    }

    public void removeMethods(Collection methodList) {
        this.removeMethods(methodList.iterator());
    }

    public void removeMethods(Iterator methodStream) {
        while (methodStream.hasNext()) {
            this.removeMethod((MWMethod)methodStream.next());
        }
    }

    public void clearMethods() {
        this.removeMethods(this.methods());
    }

    private Iterator typeHandles() {
        this.checkForPartiallyPopulatedCoreType();
        return new CloneIterator(this.typeHandles){

            @Override
            protected void remove(Object current) {
                MWClass.this.removeTypeHandle((MWClassHandle)current);
            }

            @Override
            public String toString() {
                return "MWClass.typeHandles()";
            }
        };
    }

    void removeTypeHandle(MWClassHandle handle) {
        this.typeHandles.remove(handle);
        this.fireItemRemoved(TYPES_COLLECTION, handle.getType());
    }

    public Iterator types() {
        return new TransformationIterator(this.typeHandles()){

            @Override
            protected Object transform(Object next) {
                return ((MWClassHandle)next).getType();
            }

            @Override
            public String toString() {
                return "MWClass.types()";
            }
        };
    }

    public int typesSize() {
        this.checkForPartiallyPopulatedCoreType();
        return this.typeHandles.size();
    }

    public void addType(MWClass type) {
        this.checkForPartiallyPopulatedCoreType();
        this.typeHandles.add(new MWClassHandle(this, type, this.typeScrubber()));
        this.fireItemAdded(TYPES_COLLECTION, type);
    }

    public void addTypes(Collection types) {
        this.addTypes(types.iterator());
    }

    public void addTypes(Iterator types) {
        while (types.hasNext()) {
            this.addType((MWClass)types.next());
        }
    }

    public void removeType(MWClass type) {
        Iterator stream = this.types();
        while (stream.hasNext()) {
            if (stream.next() != type) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(type.toString());
    }

    public void removeTypes(Collection types) {
        this.removeTypes(types.iterator());
    }

    public void removeTypes(Iterator types) {
        while (types.hasNext()) {
            this.removeType((MWClass)types.next());
        }
    }

    public void clearTypes() {
        Iterator stream = this.typeHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    @Override
    public boolean supportsAbstract() {
        return true;
    }

    @Override
    public boolean canBeSetAbstract() {
        return !this.getModifier().isFinal();
    }

    @Override
    public boolean canBeSetFinal() {
        return !this.isAbstract();
    }

    @Override
    public boolean supportsInterface() {
        return true;
    }

    @Override
    public boolean canBeSetInterface() {
        return true;
    }

    @Override
    public boolean supportsNative() {
        return false;
    }

    @Override
    public boolean canBeSetNative() {
        return false;
    }

    @Override
    public boolean canBeSetPackage() {
        return true;
    }

    @Override
    public boolean canBeSetPrivate() {
        return this.isMemberType();
    }

    @Override
    public boolean canBeSetProtected() {
        return this.isMemberType();
    }

    @Override
    public boolean canBeSetPublic() {
        return true;
    }

    @Override
    public boolean canBeSetStatic() {
        return this.isMemberType();
    }

    public boolean isStrict() {
        return this.getModifier().isStrict() || this.getDeclaringType() != null && this.getDeclaringType().isStrict();
    }

    @Override
    public boolean supportsStrict() {
        return true;
    }

    @Override
    public boolean canBeSetStrict() {
        return true;
    }

    @Override
    public boolean supportsSynchronized() {
        return false;
    }

    @Override
    public boolean canBeSetSynchronized() {
        return false;
    }

    @Override
    public boolean supportsTransient() {
        return false;
    }

    @Override
    public boolean canBeSetTransient() {
        return false;
    }

    @Override
    public boolean supportsVolatile() {
        return false;
    }

    @Override
    public boolean canBeSetVolatile() {
        return false;
    }

    @Override
    public void modifierChanged(int oldCode, int newCode) {
        this.firePropertyChanged("modifierCode", oldCode, newCode);
        if (MWModifier.anyFlagsAreDifferent(1040, oldCode, newCode)) {
            this.modifier.allowedModifiersChanged();
        }
        if (MWModifier.anyFlagsAreDifferent(3088, oldCode, newCode)) {
            this.notifyMethodsOfAllowedModifiersChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMethodsOfAllowedModifiersChange() {
        Collection collection = this.methods;
        synchronized (collection) {
            Iterator stream = this.methods.iterator();
            while (stream.hasNext()) {
                ((MWMethod)stream.next()).allowedModifiersChanged();
            }
        }
    }

    @Override
    public void accessLevelChanged(String oldValue, String newValue) {
        this.firePropertyChanged("modifierAccessLevel", oldValue, newValue);
    }

    public Iterator externalClassDescriptions() {
        return this.getRepository().externalClassDescriptionsNamed(this.getName());
    }

    @Override
    public String getAdditionalInfo() {
        return this.getProject().getName();
    }

    public boolean isMemberType() {
        return this.getDeclaringType() != null;
    }

    public boolean isReferenceType() {
        return !this.isNonReferenceType();
    }

    public boolean isNonReferenceType() {
        return this.isPrimitive() || this.isVoid();
    }

    public boolean isAbstract() {
        return this.getModifier().isAbstract() || this.isInterface();
    }

    public boolean isConcrete() {
        return !this.isAbstract();
    }

    public Iterator declaringTypeLineage() {
        return new ChainIterator(this){

            @Override
            protected Object nextLink(Object currentLink) {
                return ((MWClass)currentLink).getDeclaringType();
            }

            @Override
            public String toString() {
                return "MWClass.declaringTypeLineage()";
            }
        };
    }

    public boolean declaringTypeLineageContains(MWClass type) {
        return CollectionTools.contains(this.declaringTypeLineage(), (Object)type);
    }

    public Iterator declaringTypes() {
        MWClass dt = this.getDeclaringType();
        if (dt == null) {
            return NullIterator.instance();
        }
        return dt.declaringTypeLineage();
    }

    public boolean isStub() {
        if (this.isCoreType()) {
            return false;
        }
        return this.declaringTypeIsDefaultValue() && this.modifier.isDefaultValue() && this.superclassIsDefaultValue() && this.interfaceHandles.isEmpty() && this.getComment().length() == 0 && this.attributes.isEmpty() && this.ejb20Attributes.isEmpty() && this.unknownPrimaryKeyAttribute == null && this.methods.isEmpty() && this.typeHandles.isEmpty();
    }

    public boolean isFullyPopulated() {
        return !this.isStub();
    }

    public boolean isFullyTyped() {
        Iterator stream = this.lineageIncludingInterfaces();
        while (stream.hasNext()) {
            if (!((MWClass)stream.next()).isStub()) continue;
            return false;
        }
        return true;
    }

    private boolean declaringTypeIsDefaultValue() {
        return this.getDeclaringType() == this.defaultDeclaringType();
    }

    private boolean superclassIsDefaultValue() {
        if (this.cannotHaveSuperclass()) {
            return this.getSuperclass() == null;
        }
        return this.getSuperclass().getName().equals(Object.class.getName());
    }

    Iterator expandedInterfaces() {
        class ExpandedInterfacesTreeIterator
        extends TreeIterator {
            ExpandedInterfacesTreeIterator(Object root) {
                super(root);
            }

            ExpandedInterfacesTreeIterator(Iterator roots) {
                super(roots);
            }

            @Override
            protected Iterator children(Object next) {
                return ((MWClass)next).interfaces();
            }
        }
        return this.isInterface() ? new ExpandedInterfacesTreeIterator(this) : new ExpandedInterfacesTreeIterator(this.interfaces());
    }

    public Iterator allInterfaces() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            @Override
            protected Object transform(Object next) {
                return ((MWClass)next).expandedInterfaces();
            }

            @Override
            public String toString() {
                return "MWClass.allInterfaces()";
            }
        });
    }

    public Iterator allInterfacesWithoutDuplicates() {
        return CollectionTools.set(this.allInterfaces()).iterator();
    }

    public boolean allInterfacesContains(MWClass interfaceX) {
        return CollectionTools.contains(this.allInterfaces(), (Object)interfaceX);
    }

    public Iterator allAttributes() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            @Override
            protected Object transform(Object next) {
                return ((MWClass)next).attributes();
            }

            @Override
            public String toString() {
                return "MWClass.allAttributes()";
            }
        });
    }

    public Iterator attributeNames() {
        return this.attributeNames(this.attributes());
    }

    public Iterator visibleAttributeNames() {
        return this.attributeNames(this.visibleAttributes());
    }

    private Iterator attributeNames(Iterator attrs) {
        return new TransformationIterator(attrs){

            @Override
            protected Object transform(Object next) {
                return ((MWClassAttribute)next).getName();
            }

            @Override
            public String toString() {
                return "MWClass.attributeNames(Iterator)";
            }
        };
    }

    public MWClassAttribute attributeNamed(String attributeName) {
        return this.attributeNamed(this.attributes(), attributeName);
    }

    public boolean containsAttributeNamed(String attributeName) {
        return this.attributeNamed(attributeName) != null;
    }

    public MWClassAttribute attributeNamedFromAll(String attributeName) {
        return this.attributeNamed(this.allAttributes(), attributeName);
    }

    public boolean containsAttributeNamedFromAll(String attributeName) {
        return this.attributeNamedFromAll(attributeName) != null;
    }

    public MWClassAttribute attributeNamedFromCombinedAll(String attributeName) {
        return this.attributeNamed(this.allCombinedAttributes(), attributeName);
    }

    public boolean containsAttributeNamedFromCombinedAll(String attributeName) {
        return this.attributeNamedFromCombinedAll(attributeName) != null;
    }

    private MWClassAttribute attributeNamed(Iterator attrs, String attributeName) {
        while (attrs.hasNext()) {
            MWClassAttribute attribute = (MWClassAttribute)attrs.next();
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public Iterator instanceVariables() {
        return this.instanceVariables(this.attributes());
    }

    public Iterator allInstanceVariables() {
        return this.instanceVariables(this.allAttributes());
    }

    private Iterator instanceVariables(Iterator attrs) {
        return new FilteringIterator(attrs){

            @Override
            protected boolean accept(Object next) {
                return ((MWClassAttribute)next).isInstanceVariable();
            }

            @Override
            public String toString() {
                return "MWClass.instanceVariables(Iterator)";
            }
        };
    }

    public Iterator visibleAttributes() {
        return this.visibleAttributes(this.allAttributes());
    }

    private Iterator visibleAttributes(Iterator attrs) {
        return new FilteringIterator(attrs){

            @Override
            protected boolean accept(Object next) {
                MWClassAttribute attribute = (MWClassAttribute)next;
                if (attribute.getDeclaringType() == MWClass.this) {
                    return true;
                }
                if (attribute.getModifier().isPrivate()) {
                    return false;
                }
                if (attribute.getModifier().isPublic() || attribute.getModifier().isProtected()) {
                    return true;
                }
                return MWClass.this.packageName().equals(attribute.getDeclaringType().packageName());
            }

            @Override
            public String toString() {
                return "MWClass.visibleAttributes(Iterator)";
            }
        };
    }

    public Iterator allEjb20Attributes() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            @Override
            protected Object transform(Object next) {
                return ((MWClass)next).ejb20Attributes();
            }

            @Override
            public String toString() {
                return "MWClass.allEjb20Attributes()";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWClassAttribute ejb20AttributeNamed(String attributeName) {
        Collection collection = this.ejb20Attributes;
        synchronized (collection) {
            return this.attributeNamed(this.ejb20Attributes.iterator(), attributeName);
        }
    }

    public boolean containsEjb20AttributeNamed(String attributeName) {
        return this.ejb20AttributeNamed(attributeName) != null;
    }

    boolean ejb20AttributesContains(MWClassAttribute attribute) {
        return this.ejb20Attributes.contains(attribute);
    }

    public MWClassAttribute ejb20AttributeNamedFromAll(String attributeName) {
        return this.attributeNamed(this.allEjb20Attributes(), attributeName);
    }

    public boolean containsEjb20AttributeNamedFromAll(String attributeName) {
        return this.ejb20AttributeNamedFromAll(attributeName) != null;
    }

    public Iterator combinedAttributes() {
        return new CompositeIterator(this.attributes(), this.ejb20Attributes());
    }

    public MWClassAttribute combinedAttributeNamed(String attributeName) {
        return this.attributeNamed(this.combinedAttributes(), attributeName);
    }

    public boolean containsCombinedAttributeNamed(String attributeName) {
        return this.combinedAttributeNamed(attributeName) != null;
    }

    public Iterator allCombinedAttributes() {
        return this.unknownPrimaryKeyAttribute == null ? new CompositeIterator(this.allAttributes(), this.allEjb20Attributes()) : new CompositeIterator(this.allAttributes(), this.allEjb20Attributes(), new SingleElementIterator(this.unknownPrimaryKeyAttribute));
    }

    public Iterator allMethods() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            @Override
            protected Object transform(Object next) {
                return ((MWClass)next).methods();
            }

            @Override
            public String toString() {
                return "MWClass.allMethods()";
            }
        });
    }

    public Iterator constructors() {
        return new FilteringIterator(this.methods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isConstructor();
            }

            @Override
            public String toString() {
                return "MWClass.constructors()";
            }
        };
    }

    public Iterator nonConstructors() {
        return this.nonConstructors(this.methods());
    }

    public Iterator allNonConstructors() {
        return this.nonConstructors(this.allMethods());
    }

    private Iterator nonConstructors(Iterator methodStream) {
        return new FilteringIterator(methodStream){

            @Override
            protected boolean accept(Object next) {
                return !((MWMethod)next).isConstructor();
            }

            @Override
            public String toString() {
                return "MWClass.nonConstructors(Iterator)";
            }
        };
    }

    public Iterator instanceMethods() {
        return this.instanceMethods(this.methods());
    }

    public Iterator allInstanceMethods() {
        return this.instanceMethods(this.allMethods());
    }

    private Iterator instanceMethods(Iterator methodStream) {
        return new FilteringIterator(methodStream){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isInstanceMethod();
            }

            @Override
            public String toString() {
                return "MWClass.instanceMethods(Iterator)";
            }
        };
    }

    public Iterator staticMethods() {
        return this.staticMethods(this.methods());
    }

    public Iterator allStaticMethods() {
        return this.staticMethods(this.allMethods());
    }

    private Iterator staticMethods(Iterator methodStream) {
        return new FilteringIterator(methodStream){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isStatic();
            }

            @Override
            public String toString() {
                return "MWClass.staticMethods(Iterator)";
            }
        };
    }

    public Iterator candidateTopLinkGetMethods() {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateTopLinkGetMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateTopLinkGetMethods()";
            }
        };
    }

    public Iterator candidateTopLinkSetMethods() {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateTopLinkSetMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateTopLinkSetMethods()";
            }
        };
    }

    public Iterator candidateMapContainerPolicyKeyMethods() {
        return new FilteringIterator(this.allMethods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateMapContainerPolicyKeyMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateMapContainerPolicyKeyMethods()";
            }
        };
    }

    public Iterator candidateClassExtractionMethods() {
        return new FilteringIterator(this.allMethods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateClassExtractionMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateClassExtractionMethods()";
            }
        };
    }

    public Iterator candidateCloneMethods() {
        return new FilteringIterator(this.allMethods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateCloneMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateCloneMethods()";
            }
        };
    }

    public Iterator candidateDescriptorEventMethods() {
        return new FilteringIterator(this.allMethods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateDescriptorEventMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateDescriptorEventMethods()";
            }
        };
    }

    public Iterator candidateFactoryMethods() {
        return new FilteringIterator(this.methods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateFactoryMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateFactoryMethods()";
            }
        };
    }

    public Iterator candidateInstantiationMethods() {
        return new FilteringIterator(this.methods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateInstantiationMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateInstantiationMethods()";
            }
        };
    }

    public Iterator candidateFactoryInstantiationMethodsFor(final MWClass type) {
        return new FilteringIterator(this.allMethods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateFactoryInstantiationMethodFor(type);
            }

            @Override
            public String toString() {
                return "MWClass.candidateFactoryInstantiationMethodsFor(MWClass)";
            }
        };
    }

    public Iterator candidateDescriptorAfterLoadMethods() {
        return new FilteringIterator(this.methods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateDescriptorAfterLoadMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateDescriptorAfterLoadMethods()";
            }
        };
    }

    public Iterator candidateAttributeTransformerMethods() {
        return new FilteringIterator(this.allMethods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateAttributeTransformerMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateAttributeTransformerMethods()";
            }
        };
    }

    public Iterator candidateFieldTransformerMethods() {
        return new FilteringIterator(this.allMethods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isCandidateFieldTransformerMethod();
            }

            @Override
            public String toString() {
                return "MWClass.candidateFieldTransformerMethods()";
            }
        };
    }

    Iterator candidateGetMethodsFor(final MWClassAttribute attribute) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateGetMethodFor(attribute);
            }

            @Override
            public String toString() {
                return "MWClass.candidateGetMethodsFor(MWClassAttribute)";
            }
        };
    }

    Iterator candidateSetMethodsFor(final MWClassAttribute attribute) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateSetMethodFor(attribute);
            }

            @Override
            public String toString() {
                return "MWClass.candidateSetMethodsFor(MWClassAttribute)";
            }
        };
    }

    Iterator candidateGetMethodsFor(final MWClass type) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateGetMethodFor(type);
            }

            @Override
            public String toString() {
                return "MWClass.candidateGetMethodsFor(MWClass)";
            }
        };
    }

    Iterator candidateSetMethodsFor(final MWClass type) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateSetMethodFor(type);
            }

            @Override
            public String toString() {
                return "MWClass.candidateSetMethodsFor(MWClass)";
            }
        };
    }

    Iterator candidateAddMethodsFor(final MWClass itemType) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateAddMethodFor(itemType);
            }

            @Override
            public String toString() {
                return "MWClass.candidateAddMethodsFor(MWClass)";
            }
        };
    }

    Iterator candidateAddMethodsFor(final MWClass keyType, final MWClass itemType) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateAddMethodFor(keyType, itemType);
            }

            @Override
            public String toString() {
                return "MWClass.candidateAddMethodsFor(MWClass, MWClass)";
            }
        };
    }

    Iterator candidateRemoveMethodsFor(final MWClass itemOrKeyType) {
        return new FilteringIterator(this.methods()){

            @Override
            public boolean accept(Object next) {
                return ((MWMethod)next).isCandidateRemoveMethodFor(itemOrKeyType);
            }

            @Override
            public String toString() {
                return "MWClass.candidateRemoveMethodsFor(MWClass)";
            }
        };
    }

    private Iterator ejb20GetMethods() {
        return new FilteringIterator(this.methods()){

            @Override
            protected boolean accept(Object next) {
                return ((MWMethod)next).isEjb20GetMethod();
            }

            @Override
            public String toString() {
                return "MWClass.ejb20GetMethods()";
            }
        };
    }

    MWMethod ejb20SetMethodFor(MWMethod ejb20GetMethod) {
        Iterator stream = this.methods();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            if (!method.isEjb20SetMethodFor(ejb20GetMethod)) continue;
            return method;
        }
        return null;
    }

    MWMethod zeroArgumentMethodNamed(String methodName) {
        Iterator stream = this.methods();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            if (!method.hasSignature(methodName)) continue;
            return method;
        }
        return null;
    }

    MWMethod oneArgumentMethodNamed(String methodName, MWClass type) {
        return this.oneArgumentMethodNamed(methodName, type, 0);
    }

    MWMethod oneArgumentMethodNamed(String methodName, MWClass type, int dimensionality) {
        Iterator stream = this.methods();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            if (!method.hasSignature(methodName, type, dimensionality)) continue;
            return method;
        }
        return null;
    }

    MWMethod oneArgumentMethodNamed(String methodName, MWTypeDeclaration declaration) {
        return this.oneArgumentMethodNamed(methodName, declaration.getType(), declaration.getDimensionality());
    }

    MWMethod twoArgumentMethodNamed(String methodName, MWClass type1, MWClass type2) {
        Iterator stream = this.methods();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            if (!method.hasSignature(methodName, type1, 0, type2, 0)) continue;
            return method;
        }
        return null;
    }

    public MWMethod methodWithSignature(String signature) {
        return this.methodWithSignature(this.methods(), signature);
    }

    public MWMethod methodWithSignatureFromAll(String signature) {
        return this.methodWithSignature(this.allMethods(), signature);
    }

    private MWMethod methodWithSignature(Iterator methodStream, String signature) {
        while (methodStream.hasNext()) {
            MWMethod method = (MWMethod)methodStream.next();
            if (!method.signature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public MWMethod zeroArgumentConstructor() {
        Iterator stream = this.methods();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            if (!method.isZeroArgumentConstructor()) continue;
            return method;
        }
        return null;
    }

    public boolean hasAccessibleZeroArgumentConstructor() {
        if (this.isObject()) {
            return true;
        }
        return this.zeroArgumentConstructor() != null || this.inheritsAccessibleZeroArgumentConstructor();
    }

    private boolean inheritsAccessibleZeroArgumentConstructor() {
        return !this.constructors().hasNext() && this.getSuperclass() != null && this.getSuperclass().hasAccessibleZeroArgumentConstructor();
    }

    public boolean isAssignableFrom(MWClass other) {
        if (this == other) {
            return true;
        }
        if (CollectionTools.contains(other.superclasses(), (Object)this)) {
            return true;
        }
        if (CollectionTools.contains(other.allInterfaces(), (Object)this)) {
            return true;
        }
        return other.isInterface() && this.isObject();
    }

    public boolean mightBeAssignableFrom(MWClass other) {
        return this.isAssignableFrom(other) || !other.isFullyTyped();
    }

    public boolean isAssignableTo(MWClass other) {
        return other.isAssignableFrom(this);
    }

    public boolean mightBeAssignableTo(MWClass other) {
        return other.mightBeAssignableFrom(this);
    }

    public boolean isBooleanPrimitive() {
        return this == this.booleanPrimitiveType();
    }

    public boolean isCharPrimitive() {
        return this == this.charPrimitiveType();
    }

    public boolean isBytePrimitive() {
        return this == this.bytePrimitiveType();
    }

    public boolean isShortPrimitive() {
        return this == this.shortPrimitiveType();
    }

    public boolean isIntPrimitive() {
        return this == this.intPrimitiveType();
    }

    public boolean isLongPrimitive() {
        return this == this.longPrimitiveType();
    }

    public boolean isFloatPrimitive() {
        return this == this.floatPrimitiveType();
    }

    public boolean isDoublePrimitive() {
        return this == this.doublePrimitiveType();
    }

    public boolean isObject() {
        return this == this.objectType();
    }

    public boolean isSerializable() {
        return this == this.serializableType();
    }

    public boolean isCloneable() {
        return this == this.cloneableType();
    }

    public boolean isAssignableToCollection() {
        return this.isAssignableTo(this.collectionType());
    }

    public boolean mightBeAssignableToCollection() {
        return this.mightBeAssignableTo(this.collectionType());
    }

    public boolean isAssignableToList() {
        return this.isAssignableTo(this.listType());
    }

    public boolean mightBeAssignableToList() {
        return this.mightBeAssignableTo(this.listType());
    }

    public boolean isAssignableToMap() {
        return this.isAssignableTo(this.mapType());
    }

    public boolean mightBeAssignableToMap() {
        return this.mightBeAssignableTo(this.mapType());
    }

    public boolean isAssignableToSet() {
        return this.isAssignableTo(this.setType());
    }

    public boolean mightBeAssignableToSet() {
        return this.mightBeAssignableTo(this.setType());
    }

    public boolean mightBeAssignableToSortedSet() {
        return this.mightBeAssignableTo(this.sortedSetType());
    }

    public boolean mightBeAssignableToComparator() {
        return this.mightBeAssignableTo(this.comparatorType());
    }

    public boolean isAssignableToIndirectContainer() {
        return this.isAssignableTo(this.indirectContainerType());
    }

    public boolean mightBeAssignableToIndirectContainer() {
        return this.mightBeAssignableTo(this.indirectContainerType());
    }

    public boolean isAssignableToAttributeTransformer() {
        return this.isAssignableTo(this.attributeTransformerType());
    }

    public boolean mightBeAssignableToAttributeTransformer() {
        return this.mightBeAssignableTo(this.attributeTransformerType());
    }

    public boolean isAssignableToFieldTransformer() {
        return this.isAssignableTo(this.fieldTransformerType());
    }

    public boolean mightBeAssignableToFieldTransformer() {
        return this.mightBeAssignableTo(this.fieldTransformerType());
    }

    public boolean isContainer() {
        return this.isAssignableToCollection() || this.isAssignableToMap();
    }

    public boolean isSubclassOf(MWClass type) {
        return CollectionTools.contains(this.superclasses(), (Object)type);
    }

    public boolean isValueHolder() {
        return this == this.valueHolderType();
    }

    public boolean isVoid() {
        return this.getName().equals(MWClass.voidClassName());
    }

    public boolean isInstantiable() {
        return this.isConcrete() && this.isReferenceType();
    }

    public boolean cannotHaveSuperclass() {
        if (this.isNonReferenceType()) {
            return true;
        }
        if (this.isInterface()) {
            return true;
        }
        return this.getName().equals(Object.class.getName());
    }

    public boolean requiresSuperclass() {
        return !this.cannotHaveSuperclass();
    }

    public Iterator lineage() {
        return new ChainIterator(this){

            @Override
            protected Object nextLink(Object currentLink) {
                return ((MWClass)currentLink).getSuperclass();
            }

            @Override
            public String toString() {
                return "MWClass.lineage()";
            }
        };
    }

    public Iterator lineageIncludingInterfaces() {
        return new TreeIterator(this){

            @Override
            protected Iterator children(Object next) {
                MWClass type = (MWClass)next;
                MWClass superType = type.getSuperclass();
                return superType == null ? type.interfaces() : new CompositeIterator(superType, type.interfaces());
            }

            @Override
            public String toString() {
                return "MWClass.lineageIncludingInterfaces()";
            }
        };
    }

    public Iterator lineageTo(final MWClass superclass) {
        return new ChainIterator(this){

            @Override
            protected Object nextLink(Object currentLink) {
                return currentLink == superclass ? null : ((MWClass)currentLink).getSuperclass();
            }

            @Override
            public String toString() {
                return "MWClass.lineageTo(MWClass)";
            }
        };
    }

    public boolean lineageContains(MWClass type) {
        return CollectionTools.contains(this.lineage(), (Object)type);
    }

    public Iterator superclasses() {
        MWClass sc = this.getSuperclass();
        return sc == null ? NullIterator.instance() : sc.lineage();
    }

    public Iterator subclasses() {
        return this.getRepository().subclassesOf(this);
    }

    public Iterator allSubclasses() {
        return this.getRepository().allSubclassesOf(this);
    }

    public Iterator hierarchy() {
        return new CompositeIterator(this.lineage(), this.allSubclasses());
    }

    private MWClass booleanPrimitiveType() {
        return this.typeFor(Boolean.TYPE);
    }

    private MWClass charPrimitiveType() {
        return this.typeFor(Character.TYPE);
    }

    private MWClass bytePrimitiveType() {
        return this.typeFor(Byte.TYPE);
    }

    private MWClass shortPrimitiveType() {
        return this.typeFor(Short.TYPE);
    }

    private MWClass intPrimitiveType() {
        return this.typeFor(Integer.TYPE);
    }

    private MWClass longPrimitiveType() {
        return this.typeFor(Long.TYPE);
    }

    private MWClass floatPrimitiveType() {
        return this.typeFor(Float.TYPE);
    }

    private MWClass doublePrimitiveType() {
        return this.typeFor(Double.TYPE);
    }

    private MWClass objectType() {
        return this.typeFor(Object.class);
    }

    private MWClass cloneableType() {
        return this.typeFor(Cloneable.class);
    }

    private MWClass serializableType() {
        return this.typeFor(Serializable.class);
    }

    private MWClass collectionType() {
        return this.typeFor(Collection.class);
    }

    private MWClass listType() {
        return this.typeFor(List.class);
    }

    private MWClass mapType() {
        return this.typeFor(Map.class);
    }

    private MWClass setType() {
        return this.typeFor(Set.class);
    }

    private MWClass sortedSetType() {
        return this.typeFor(SortedSet.class);
    }

    private MWClass comparatorType() {
        return this.typeFor(Comparator.class);
    }

    private MWClass indirectContainerType() {
        return this.typeFor(IndirectContainer.class);
    }

    private MWClass attributeTransformerType() {
        return this.typeFor(AttributeTransformer.class);
    }

    private MWClass fieldTransformerType() {
        return this.typeFor(FieldTransformer.class);
    }

    private MWClass valueHolderType() {
        return this.typeFor(ValueHolderInterface.class);
    }

    public boolean typesContains(MWClass type) {
        return CollectionTools.contains(this.types(), (Object)type);
    }

    public String defaultTableNameWithLength(int maxLength) {
        String tableName = this.shortName().toUpperCase();
        return tableName.length() <= maxLength ? tableName : tableName.substring(0, maxLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.modifier);
        children.add(this.declaringTypeHandle);
        children.add(this.superclassHandle);
        Collection collection = this.interfaceHandles;
        synchronized (collection) {
            children.addAll(this.interfaceHandles);
        }
        collection = this.typeHandles;
        synchronized (collection) {
            children.addAll(this.typeHandles);
        }
        collection = this.attributes;
        synchronized (collection) {
            children.addAll(this.attributes);
        }
        collection = this.methods;
        synchronized (collection) {
            children.addAll(this.methods);
        }
        collection = this.ejb20Attributes;
        synchronized (collection) {
            children.addAll(this.ejb20Attributes);
        }
        if (this.unknownPrimaryKeyAttribute != null) {
            children.add(this.unknownPrimaryKeyAttribute);
        }
    }

    private MWHandle.NodeReferenceScrubber buildDeclaringTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClass.this.setDeclaringType(null);
            }

            public String toString() {
                return "MWClass.buildDeclaringTypeScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildSuperclassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClass.this.setSuperclass(null);
            }

            public String toString() {
                return "MWClass.buildSuperclassScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber interfaceScrubber() {
        if (this.interfaceScrubber == null) {
            this.interfaceScrubber = this.buildInterfaceScrubber();
        }
        return this.interfaceScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildInterfaceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClass.this.removeInterfaceHandle((MWClassHandle)handle);
            }

            public String toString() {
                return "MWClass.buildInterfaceScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber typeScrubber() {
        if (this.typeScrubber == null) {
            this.typeScrubber = this.buildTypeScrubber();
        }
        return this.typeScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClass.this.removeTypeHandle((MWClassHandle)handle);
            }

            public String toString() {
                return "MWClass.buildTypeScrubber()";
            }
        };
    }

    @Override
    protected void aspectChanged(String aspectName) {
        super.aspectChanged(aspectName);
        this.getRepository().typeChanged(this);
    }

    @Override
    protected void markParentBranchDirty() {
        if (!this.isCoreType()) {
            super.markParentBranchDirty();
        }
    }

    void configureImpliedStubInterfaces() {
        Iterator stream = this.interfaces();
        while (stream.hasNext()) {
            ((MWClass)stream.next()).configureAsImpliedStubInterface();
        }
    }

    private void configureAsImpliedStubInterface() {
        if (this.isStub()) {
            this.interfaceFlag = true;
            this.superclassHandle.setType(null);
        }
    }

    private synchronized void checkForPartiallyPopulatedCoreType() {
        if (this.partiallyPopulatedCoreType) {
            this.coreTypeRefreshInProgress = true;
            try {
                this.refreshMembers();
            }
            catch (ExternalClassNotFoundException ex) {
                throw new RuntimeException(this.name, ex);
            }
            finally {
                this.coreTypeRefreshInProgress = false;
            }
        }
    }

    public void refresh() throws ExternalClassNotFoundException {
        this.refresh(DefaultMWClassRefreshPolicy.instance());
    }

    public void refresh(MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException {
        this.getRepository().refreshType(this, refreshPolicy);
    }

    void refreshDeclaration(ExternalClass externalClass) throws ExternalClassNotFoundException {
        try {
            if (!this.getName().equals(externalClass.getName())) {
                throw new IllegalArgumentException(this.getName() + " != " + externalClass.getName());
            }
            this.refreshDeclaringType(externalClass.getDeclaringClass());
            this.getModifier().refresh(externalClass.getModifiers());
            this.setInterface(externalClass.isInterface());
            this.refreshSuperclass(externalClass.getSuperclass());
            this.refreshInterfaces(externalClass.getInterfaces());
        }
        catch (Throwable t) {
            throw new ExternalClassNotFoundException(this.getName(), t);
        }
        this.setLastRefreshTimestamp(new Date());
    }

    void refresh(ExternalClass externalClass) throws ExternalClassNotFoundException {
        this.refresh(externalClass, DefaultMWClassRefreshPolicy.instance());
    }

    void refresh(ExternalClass externalClass, MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException {
        this.refreshDeclaration(externalClass);
        this.refreshMembers(externalClass, refreshPolicy);
    }

    private void refreshMembers() throws ExternalClassNotFoundException {
        this.refreshMembers(DefaultMWClassRefreshPolicy.instance());
    }

    private void refreshMembers(MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException {
        this.getRepository().refreshTypeMembers(this, refreshPolicy);
    }

    synchronized void refreshMembers(ExternalClass externalClass, MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException {
        this.partiallyPopulatedCoreType = false;
        try {
            this.refreshAttributes(externalClass.getDeclaredFields(), refreshPolicy);
            this.refreshConstructors(externalClass.getDeclaredConstructors());
            this.refreshMethods(externalClass.getDeclaredMethods());
            this.refreshTypes(externalClass.getDeclaredClasses());
        }
        catch (Throwable t) {
            throw new ExternalClassNotFoundException(this.getName(), t);
        }
        refreshPolicy.finalizeRefresh(this);
    }

    private void refreshDeclaringType(ExternalClassDescription declaringExternalClassDescription) {
        if (declaringExternalClassDescription == null) {
            this.setDeclaringType(null);
        } else {
            this.setDeclaringType(this.typeNamed(declaringExternalClassDescription.getName()));
        }
    }

    private void refreshSuperclass(ExternalClassDescription superExternalClassDescription) {
        if (superExternalClassDescription == null) {
            this.setSuperclass(null);
        } else {
            this.setSuperclass(this.typeNamed(superExternalClassDescription.getName()));
        }
    }

    private void refreshInterfaces(ExternalClassDescription[] externalInterfaces) {
        Collection removedInterfaces = CollectionTools.collection(this.interfaces());
        for (int i = 0; i < externalInterfaces.length; ++i) {
            MWClass mwInterface = this.getRepository().typeNamed(externalInterfaces[i].getName());
            mwInterface.configureAsImpliedStubInterface();
            if (removedInterfaces.remove(mwInterface)) continue;
            this.addInterface(mwInterface);
        }
        this.removeInterfaces(removedInterfaces);
    }

    private void refreshAttributes(ExternalField[] externalFields, MWClassRefreshPolicy refreshPolicy) {
        refreshPolicy.refreshAttributes(this, externalFields);
    }

    private void refreshConstructors(ExternalConstructor[] externalConstructors) {
        Collection removedConstructors = CollectionTools.collection(this.constructors());
        for (int i = 0; i < externalConstructors.length; ++i) {
            this.refreshConstructor(externalConstructors[i], removedConstructors);
        }
        this.removeMethods(removedConstructors);
    }

    private void refreshConstructor(ExternalConstructor externalConstructor, Collection removedConstructors) {
        MWMethod existingConstructor = this.constructorWithSameSignatureAs(externalConstructor);
        if (existingConstructor == null) {
            this.addMethod(new MWMethod(this, externalConstructor));
        } else {
            existingConstructor.refresh(externalConstructor);
            removedConstructors.remove(existingConstructor);
        }
    }

    private MWMethod constructorWithSameSignatureAs(ExternalConstructor externalConstructor) {
        Iterator stream = this.constructors();
        while (stream.hasNext()) {
            MWMethod constructor = (MWMethod)stream.next();
            if (!constructor.hasSameSignatureAs(externalConstructor)) continue;
            return constructor;
        }
        return null;
    }

    private void refreshMethods(ExternalMethod[] externalMethods) {
        Collection removedMethods = CollectionTools.collection(this.nonConstructors());
        for (int i = 0; i < externalMethods.length; ++i) {
            this.refreshMethod(externalMethods[i], removedMethods);
        }
        this.removeMethods(removedMethods);
    }

    private void refreshMethod(ExternalMethod externalMethod, Collection removedMethods) {
        if (externalMethod.isSynthetic()) {
            return;
        }
        MWMethod existingMethod = this.methodWithSameSignatureAs(externalMethod);
        if (existingMethod == null) {
            this.addMethod(new MWMethod(this, externalMethod));
        } else {
            existingMethod.refresh(externalMethod);
            removedMethods.remove(existingMethod);
        }
    }

    private MWMethod methodWithSameSignatureAs(ExternalMethod externalMethod) {
        Iterator stream = this.nonConstructors();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            if (!method.hasSameSignatureAs(externalMethod)) continue;
            return method;
        }
        return null;
    }

    private void refreshTypes(ExternalClassDescription[] externalClassDescriptions) {
        this.clearTypes();
        for (int i = 0; i < externalClassDescriptions.length; ++i) {
            MWClass mwClass = this.typeNamed(externalClassDescriptions[i].getName());
            this.addType(mwClass);
        }
    }

    public void refreshEjb20Attributes() {
        Collection removedEjb20Attributes = CollectionTools.collection(this.ejb20Attributes());
        Iterator stream = this.ejb20GetMethods();
        while (stream.hasNext()) {
            MWMethod ejb20GetMethod = (MWMethod)stream.next();
            MWMethod ejb20SetMethod = this.ejb20SetMethodFor(ejb20GetMethod);
            if (ejb20SetMethod == null) continue;
            this.refreshEjb20Attribute(ejb20GetMethod, ejb20SetMethod, removedEjb20Attributes);
        }
        this.removeEjb20Attributes(removedEjb20Attributes);
        if (this.getSuperclass() != null) {
            this.getSuperclass().refreshEjb20Attributes();
        }
    }

    private void refreshEjb20Attribute(MWMethod ejb20GetMethod, MWMethod ejb20SetMethod, Collection removedEjb20Attributes) {
        String attrName = StringTools.uncapitalize(ejb20GetMethod.getName().substring(3));
        MWClass attrType = ejb20GetMethod.getReturnType();
        int attrDim = ejb20GetMethod.getReturnTypeDimensionality();
        MWClassAttribute ejb20Attribute = this.ejb20AttributeNamed(attrName);
        if (ejb20Attribute == null) {
            ejb20Attribute = this.addEjb20AttributeInternal(attrName, attrType, attrDim);
        } else {
            ejb20Attribute.setType(attrType);
            ejb20Attribute.setDimensionality(attrDim);
            removedEjb20Attributes.remove(ejb20Attribute);
        }
        ejb20Attribute.setGetMethod(ejb20GetMethod);
        ejb20Attribute.setSetMethod(ejb20SetMethod);
    }

    public MWMethod addZeroArgumentConstructor() {
        MWMethod zeroArgCtor = this.zeroArgumentConstructor();
        if (zeroArgCtor != null) {
            return zeroArgCtor;
        }
        return this.addMethod(this.buildZeroArgumentConstructor());
    }

    void superclassesChanged() {
        this.fireCollectionChanged(SUPERCLASSES_COLLECTION);
    }

    void changeFromEjb20(MWClassAttribute attribute) {
        if (this.ejb20Attributes.remove(attribute)) {
            this.fireItemRemoved(EJB20_ATTRIBUTES_COLLECTION, attribute);
            this.attributes.add(attribute);
            this.fireItemAdded(ATTRIBUTES_COLLECTION, attribute);
        }
    }

    void changeToEjb20(MWClassAttribute attribute) {
        if (this.attributes.remove(attribute)) {
            this.fireItemRemoved(ATTRIBUTES_COLLECTION, attribute);
            this.ejb20Attributes.add(attribute);
            this.fireItemAdded(EJB20_ATTRIBUTES_COLLECTION, attribute);
        }
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
    }

    public void addDescriptorProblemsTo(List currentProblems) {
        this.checkSuperclass(currentProblems);
        this.checkInterfaces(currentProblems);
        this.checkAttributes(currentProblems);
    }

    private void checkSuperclass(List currentProblems) {
        MWClass sc = this.getSuperclass();
        if (sc != null && sc.isInterface()) {
            currentProblems.add(this.buildProblem("0133", this.displayStringWithPackage()));
        }
    }

    private void checkInterfaces(List currentProblems) {
        Iterator stream = this.interfaces();
        while (stream.hasNext()) {
            MWClass type = (MWClass)stream.next();
            if (type.isInterface()) continue;
            currentProblems.add(this.buildProblem("0132", type.displayStringWithPackage()));
        }
    }

    private void checkAttributes(List currentProblems) {
        Iterator stream = this.attributes();
        while (stream.hasNext()) {
            ((MWClassAttribute)stream.next()).addDescriptorProblemsTo(currentProblems);
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    @Override
    public String displayString() {
        return this.shortName();
    }

    public String displayStringWithPackage() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.shortName());
        if (this.isReferenceType()) {
            sb.append(" (");
            sb.append(this.packageDisplayName());
            sb.append(')');
        }
        return sb.toString();
    }

    void printDefaultReturnValueOn(StringBuffer sb) {
        if (this.isVoid()) {
            throw new IllegalStateException(this.toString());
        }
        if (this.isPrimitive()) {
            if (this.isBooleanPrimitive()) {
                sb.append("false");
            } else {
                sb.append('0');
            }
        } else {
            sb.append("null");
        }
    }

    public ClassDefinition classDefinition(MWClassCodeGenPolicy classCodeGenPolicy) {
        if (this.isCoreType()) {
            return null;
        }
        ClassDefinition def = new ClassDefinition();
        def.setComment(classCodeGenPolicy.classComment(this));
        def.setPackageName(this.packageName());
        def.setAccessLevel(this.getModifier().accessLevel());
        if (this.isInterface()) {
            def.setType(2);
        } else {
            def.setType(1);
        }
        def.setName(this.shortName());
        MWClass superclass = this.getSuperclass();
        if (superclass != null && superclass != this.objectType()) {
            def.setSuperClass(superclass.getName());
        }
        Iterator stream = this.interfaces();
        while (stream.hasNext()) {
            def.addInterface(((MWClass)stream.next()).getName());
        }
        stream = this.attributes();
        while (stream.hasNext()) {
            def.addAttribute((AttributeDefinition)((MWClassAttribute)stream.next()).attributeDefinition());
        }
        stream = this.methods();
        while (stream.hasNext()) {
            MWMethod method = (MWMethod)stream.next();
            def.addMethod((MethodDefinition)method.methodDefinition(classCodeGenPolicy.getMethodCodeGenPolicy(method)));
        }
        def.calculateImports();
        return def;
    }

    MWClass defaultContainerImplementationType() {
        if (this.isConcrete() && this.isReferenceType() && this.isContainer()) {
            return this;
        }
        MWClass container = null;
        if (this.isAssignableToMap()) {
            container = this.typeFor(HashMap.class);
        } else if (this.isAssignableToSet()) {
            container = this.typeFor(HashSet.class);
        } else if (this.isAssignableToCollection()) {
            container = this.typeFor(ArrayList.class);
        }
        if (container == null || this.isAssignableFrom(container)) {
            return container;
        }
        return null;
    }

    private MWClassAttribute buildAttribute(String attributeName, MWClass attributeType, int attributeDimensionality) {
        return new MWClassAttribute(this, attributeName, attributeType, attributeDimensionality);
    }

    private MWClassAttribute buildEjb20Attribute(String attributeName, MWClass attributeType, int attributeDimensionality) {
        return this.buildAttribute(attributeName, attributeType, attributeDimensionality);
    }

    private MWMethod buildMethod(String methodName) {
        return new MWMethod(this, methodName);
    }

    private MWMethod buildMethod(String methodName, MWClass returnType) {
        return new MWMethod(this, methodName, returnType);
    }

    private MWMethod buildMethod(String methodName, MWClass returnType, int dimensionality) {
        return new MWMethod(this, methodName, returnType, dimensionality);
    }

    private MWMethod buildZeroArgumentConstructor() {
        return MWMethod.buildZeroArgumentConstructor(this);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClass.class);
        descriptor.setDefaultRootElement("class");
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping isInterfaceMapping = (XMLDirectMapping)descriptor.addDirectMapping("interfaceFlag", "is-interface/text()");
        isInterfaceMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping modifierMapping = (XMLDirectMapping)descriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        modifierMapping.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping declaringTypeHandleMapping = new XMLCompositeObjectMapping();
        declaringTypeHandleMapping.setAttributeName("declaringTypeHandle");
        declaringTypeHandleMapping.setSetMethodName("setDeclaringTypeHandleForTopLink");
        declaringTypeHandleMapping.setGetMethodName("getDeclaringTypeHandleForTopLink");
        declaringTypeHandleMapping.setReferenceClass(MWClassHandle.class);
        declaringTypeHandleMapping.setXPath("declaring-type-handle");
        descriptor.addMapping((DatabaseMapping)declaringTypeHandleMapping);
        XMLCompositeObjectMapping superclassHandleMapping = new XMLCompositeObjectMapping();
        superclassHandleMapping.setAttributeName("superclassHandle");
        superclassHandleMapping.setReferenceClass(MWClassHandle.class);
        superclassHandleMapping.setSetMethodName("setSuperclassHandleForTopLink");
        superclassHandleMapping.setGetMethodName("getSuperclassHandleForTopLink");
        superclassHandleMapping.setXPath("superclass-handle");
        descriptor.addMapping((DatabaseMapping)superclassHandleMapping);
        descriptor.addDirectMapping(LAST_REFRESH_TIMESTAMP_PROPERTY, "getLastRefreshTimestampForTopLink", "setLastRefreshTimestampForTopLink", "last-refresh-timestamp/text()");
        XMLCompositeCollectionMapping interfaceHandlesMapping = new XMLCompositeCollectionMapping();
        interfaceHandlesMapping.setAttributeName("interfaceHandles");
        interfaceHandlesMapping.setSetMethodName("setInterfaceHandlesForTopLink");
        interfaceHandlesMapping.setGetMethodName("getInterfaceHandlesForTopLink");
        interfaceHandlesMapping.setReferenceClass(MWClassHandle.class);
        interfaceHandlesMapping.setXPath("interface-handles/class-handle");
        descriptor.addMapping((DatabaseMapping)interfaceHandlesMapping);
        XMLCompositeCollectionMapping attributesMapping = new XMLCompositeCollectionMapping();
        attributesMapping.setAttributeName(ATTRIBUTES_COLLECTION);
        attributesMapping.setSetMethodName("setAttributesForTopLink");
        attributesMapping.setGetMethodName("getAttributesForTopLink");
        attributesMapping.setReferenceClass(MWClassAttribute.class);
        attributesMapping.setXPath("attributes/class-attribute");
        descriptor.addMapping((DatabaseMapping)attributesMapping);
        XMLCompositeCollectionMapping ejb20AttributesMapping = new XMLCompositeCollectionMapping();
        ejb20AttributesMapping.setAttributeName(EJB20_ATTRIBUTES_COLLECTION);
        ejb20AttributesMapping.setSetMethodName("setEjb20AttributesForTopLink");
        ejb20AttributesMapping.setGetMethodName("getEjb20AttributesForTopLink");
        ejb20AttributesMapping.setReferenceClass(MWClassAttribute.class);
        ejb20AttributesMapping.setXPath("ejb-20-attributes/class-attribute");
        descriptor.addMapping((DatabaseMapping)ejb20AttributesMapping);
        XMLCompositeObjectMapping unknownPrimaryKeyAttributeMapping = new XMLCompositeObjectMapping();
        unknownPrimaryKeyAttributeMapping.setAttributeName("unknownPrimaryKeyAttribute");
        unknownPrimaryKeyAttributeMapping.setReferenceClass(MWClassAttribute.class);
        unknownPrimaryKeyAttributeMapping.setXPath("unknown-primary-key-attribute");
        descriptor.addMapping((DatabaseMapping)unknownPrimaryKeyAttributeMapping);
        XMLCompositeCollectionMapping methodsMapping = new XMLCompositeCollectionMapping();
        methodsMapping.setAttributeName(METHODS_COLLECTION);
        methodsMapping.setSetMethodName("setMethodsForTopLink");
        methodsMapping.setGetMethodName("getMethodsForTopLink");
        methodsMapping.setReferenceClass(MWMethod.class);
        methodsMapping.setXPath("methods/method");
        descriptor.addMapping((DatabaseMapping)methodsMapping);
        XMLCompositeCollectionMapping typeHandlesMapping = new XMLCompositeCollectionMapping();
        typeHandlesMapping.setAttributeName("typeHandles");
        typeHandlesMapping.setSetMethodName("setTypeHandlesForTopLink");
        typeHandlesMapping.setGetMethodName("getTypeHandlesForTopLink");
        typeHandlesMapping.setReferenceClass(MWClassHandle.class);
        typeHandlesMapping.setXPath("type-handles/class-handle");
        descriptor.addMapping((DatabaseMapping)typeHandlesMapping);
        XMLDirectMapping coreTypeMapping = (XMLDirectMapping)descriptor.addDirectMapping("coreType", "core-type/text()");
        coreTypeMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private int getModifierForTopLink() {
        return this.modifier.getCode();
    }

    private void setModifierForTopLink(int code) {
        this.modifier.setCodeForTopLink(code);
    }

    private MWClassHandle getDeclaringTypeHandleForTopLink() {
        return this.declaringTypeHandle.getType() == null ? null : this.declaringTypeHandle;
    }

    private void setDeclaringTypeHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildDeclaringTypeScrubber();
        this.declaringTypeHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWClassHandle getSuperclassHandleForTopLink() {
        return this.superclassHandle.getType() == null ? null : this.superclassHandle;
    }

    private void setSuperclassHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildSuperclassScrubber();
        this.superclassHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInterfaceHandlesForTopLink() {
        Collection collection = this.interfaceHandles;
        synchronized (collection) {
            return new TreeSet(this.interfaceHandles);
        }
    }

    private void setInterfaceHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWClassHandle)stream.next()).setScrubber(this.interfaceScrubber());
        }
        this.interfaceHandles = handles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getAttributesForTopLink() {
        Collection collection = this.attributes;
        synchronized (collection) {
            return new TreeSet(this.attributes);
        }
    }

    private void setAttributesForTopLink(Collection attributes) {
        this.attributes = attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getEjb20AttributesForTopLink() {
        Collection collection = this.ejb20Attributes;
        synchronized (collection) {
            return new TreeSet(this.ejb20Attributes);
        }
    }

    private void setEjb20AttributesForTopLink(Collection ejb20Attributes) {
        this.ejb20Attributes = ejb20Attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getMethodsForTopLink() {
        Collection collection = this.methods;
        synchronized (collection) {
            return new TreeSet(this.methods);
        }
    }

    private void setMethodsForTopLink(Collection methods) {
        this.methods = methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getTypeHandlesForTopLink() {
        Collection collection = this.typeHandles;
        synchronized (collection) {
            return new TreeSet(this.typeHandles);
        }
    }

    private void setTypeHandlesForTopLink(Collection handles) {
        for (MWClassHandle handle : handles) {
            handle.setScrubber(this.typeScrubber());
        }
        this.typeHandles = handles;
    }

    @Override
    public void postProjectBuild() {
        super.postProjectBuild();
        this.primitive = this.defaultPrimitiveFlag();
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWClass.class);
        descriptor.setDefaultRootElement("class");
        descriptor.addDirectMapping(NAME_PROPERTY, "legacyGetNameForToplink", "legacySetNameForToplink", "name/text()");
        XMLDirectMapping isInterfaceMapping = (XMLDirectMapping)descriptor.addDirectMapping("interfaceFlag", "is-interface/text()");
        isInterfaceMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping modifierMapping = (XMLDirectMapping)descriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        modifierMapping.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping declaringTypeHandleMapping = new XMLCompositeObjectMapping();
        declaringTypeHandleMapping.setAttributeName("declaringTypeHandle");
        declaringTypeHandleMapping.setSetMethodName("setDeclaringTypeHandleForTopLink");
        declaringTypeHandleMapping.setGetMethodName("getDeclaringTypeHandleForTopLink");
        declaringTypeHandleMapping.setReferenceClass(MWClassHandle.class);
        declaringTypeHandleMapping.setXPath("declaring-type-handle");
        descriptor.addMapping((DatabaseMapping)declaringTypeHandleMapping);
        XMLCompositeObjectMapping superclassHandleMapping = new XMLCompositeObjectMapping();
        superclassHandleMapping.setAttributeName("superclassHandle");
        superclassHandleMapping.setReferenceClass(MWClassHandle.class);
        superclassHandleMapping.setSetMethodName("setSuperclassHandleForTopLink");
        superclassHandleMapping.setGetMethodName("getSuperclassHandleForTopLink");
        superclassHandleMapping.setXPath("superclass-handle");
        descriptor.addMapping((DatabaseMapping)superclassHandleMapping);
        descriptor.addDirectMapping(LAST_REFRESH_TIMESTAMP_PROPERTY, "last-refresh-timestamp/text()");
        XMLCompositeCollectionMapping interfaceHandlesMapping = new XMLCompositeCollectionMapping();
        interfaceHandlesMapping.setAttributeName("interfaceHandles");
        interfaceHandlesMapping.setSetMethodName("setInterfaceHandlesForTopLink");
        interfaceHandlesMapping.setGetMethodName("getInterfaceHandlesForTopLink");
        interfaceHandlesMapping.setReferenceClass(MWClassHandle.class);
        interfaceHandlesMapping.setXPath("interface-handles/class-handle");
        descriptor.addMapping((DatabaseMapping)interfaceHandlesMapping);
        XMLCompositeCollectionMapping attributesMapping = new XMLCompositeCollectionMapping();
        attributesMapping.setAttributeName(ATTRIBUTES_COLLECTION);
        attributesMapping.setSetMethodName("setAttributesForTopLink");
        attributesMapping.setGetMethodName("getAttributesForTopLink");
        attributesMapping.setReferenceClass(MWClassAttribute.class);
        attributesMapping.setXPath("attributes/class-attribute");
        descriptor.addMapping((DatabaseMapping)attributesMapping);
        XMLCompositeCollectionMapping ejb20AttributesMapping = new XMLCompositeCollectionMapping();
        ejb20AttributesMapping.setAttributeName(EJB20_ATTRIBUTES_COLLECTION);
        ejb20AttributesMapping.setSetMethodName("setEjb20AttributesForTopLink");
        ejb20AttributesMapping.setGetMethodName("getEjb20AttributesForTopLink");
        ejb20AttributesMapping.setReferenceClass(MWClassAttribute.class);
        ejb20AttributesMapping.setXPath("ejb-20-attributes/class-attribute");
        descriptor.addMapping((DatabaseMapping)ejb20AttributesMapping);
        XMLCompositeObjectMapping unknownPrimaryKeyAttributeMapping = new XMLCompositeObjectMapping();
        unknownPrimaryKeyAttributeMapping.setAttributeName("unknownPrimaryKeyAttribute");
        unknownPrimaryKeyAttributeMapping.setReferenceClass(MWClassAttribute.class);
        unknownPrimaryKeyAttributeMapping.setXPath("unknown-primary-key-attribute");
        descriptor.addMapping((DatabaseMapping)unknownPrimaryKeyAttributeMapping);
        XMLCompositeCollectionMapping methodsMapping = new XMLCompositeCollectionMapping();
        methodsMapping.setAttributeName(METHODS_COLLECTION);
        methodsMapping.setSetMethodName("setMethodsForTopLink");
        methodsMapping.setGetMethodName("getMethodsForTopLink");
        methodsMapping.setReferenceClass(MWMethod.class);
        methodsMapping.setXPath("methods/method");
        descriptor.addMapping((DatabaseMapping)methodsMapping);
        XMLCompositeCollectionMapping typeHandlesMapping = new XMLCompositeCollectionMapping();
        typeHandlesMapping.setAttributeName("typeHandles");
        typeHandlesMapping.setSetMethodName("setTypeHandlesForTopLink");
        typeHandlesMapping.setGetMethodName("getTypeHandlesForTopLink");
        typeHandlesMapping.setReferenceClass(MWClassHandle.class);
        typeHandlesMapping.setXPath("type-handles/class-handle");
        descriptor.addMapping((DatabaseMapping)typeHandlesMapping);
        XMLDirectMapping coreTypeMapping = (XMLDirectMapping)descriptor.addDirectMapping("coreType", "core-type/text()");
        coreTypeMapping.setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private String legacyGetNameForToplink() {
        return this.name;
    }

    private void legacySetNameForToplink(String legacyName) {
        this.name = MWModel.legacyReplaceToplinkDeprecatedClassReferences(legacyName);
    }

    public static String packageDisplayNameForClassNamed(String className) {
        if (MWClass.nonReferenceClassNamesContains(className)) {
            return "";
        }
        int lastPeriod = className.lastIndexOf(46);
        if (lastPeriod == -1) {
            return "(default package)";
        }
        return className.substring(0, lastPeriod);
    }

    public static String packageDisplayNameFor(Class javaClass) {
        return MWClass.packageDisplayNameForClassNamed(javaClass.getName());
    }

    private static PrimitiveWrapperPair[] buildPrimitiveWrapperPairs() {
        PrimitiveWrapperPair[] result = new PrimitiveWrapperPair[]{new PrimitiveWrapperPair(Boolean.TYPE, Boolean.class), new PrimitiveWrapperPair(Character.TYPE, Character.class), new PrimitiveWrapperPair(Byte.TYPE, Byte.class), new PrimitiveWrapperPair(Short.TYPE, Short.class), new PrimitiveWrapperPair(Integer.TYPE, Integer.class), new PrimitiveWrapperPair(Long.TYPE, Long.class), new PrimitiveWrapperPair(Float.TYPE, Float.class), new PrimitiveWrapperPair(Double.TYPE, Double.class)};
        return result;
    }

    private static synchronized PrimitiveWrapperPair[] getPrimitiveWrapperPairs() {
        if (primitiveWrapperPairs == null) {
            primitiveWrapperPairs = MWClass.buildPrimitiveWrapperPairs();
        }
        return primitiveWrapperPairs;
    }

    private static Iterator primitiveWrapperPairs() {
        return CollectionTools.iterator(MWClass.getPrimitiveWrapperPairs());
    }

    private static Iterator primitiveClasses(Iterator pairs) {
        return new TransformationIterator(pairs){

            @Override
            protected Object transform(Object next) {
                return ((PrimitiveWrapperPair)next).getPrimitiveClass();
            }

            @Override
            public String toString() {
                return "MWClass.primitiveClasses(Iterator)";
            }
        };
    }

    private static Iterator primitiveClassNames(Iterator pairs) {
        return new TransformationIterator(pairs){

            @Override
            protected Object transform(Object next) {
                return ((PrimitiveWrapperPair)next).primitiveClassName();
            }

            @Override
            public String toString() {
                return "MWClass.primitiveClassNames(Iterator)";
            }
        };
    }

    private static Iterator wrapperClasses(Iterator pairs) {
        return new TransformationIterator(pairs){

            @Override
            protected Object transform(Object next) {
                return ((PrimitiveWrapperPair)next).getWrapperClass();
            }

            @Override
            public String toString() {
                return "MWClass.wrapperClasses(Iterator)";
            }
        };
    }

    public static Class primitiveClassNamed(String className) {
        PrimitiveWrapperPair[] pairs = MWClass.getPrimitiveWrapperPairs();
        int len = pairs.length;
        for (int i = 0; i < len; ++i) {
            if (!pairs[i].primitiveClassName().equals(className)) continue;
            return pairs[i].getPrimitiveClass();
        }
        return null;
    }

    public static Iterator primitiveClasses() {
        return MWClass.primitiveClasses(MWClass.primitiveWrapperPairs());
    }

    public static Iterator primitiveWrapperClasses() {
        return MWClass.wrapperClasses(MWClass.primitiveWrapperPairs());
    }

    public static Iterator primitiveClassNames() {
        return MWClass.primitiveClassNames(MWClass.primitiveWrapperPairs());
    }

    private static synchronized PrimitiveWrapperPair getVoidPrimitiveWrapperPair() {
        if (voidPrimitiveWrapperPair == null) {
            voidPrimitiveWrapperPair = new PrimitiveWrapperPair(Void.TYPE, Void.class);
        }
        return voidPrimitiveWrapperPair;
    }

    public static Class voidClass() {
        return MWClass.getVoidPrimitiveWrapperPair().getPrimitiveClass();
    }

    public static Class voidWrapperClass() {
        return MWClass.getVoidPrimitiveWrapperPair().getWrapperClass();
    }

    public static String voidClassName() {
        return MWClass.getVoidPrimitiveWrapperPair().primitiveClassName();
    }

    private static Iterator nonReferencePrimitiveWrapperPairs() {
        return new CompositeIterator(CollectionTools.singletonIterator(MWClass.getVoidPrimitiveWrapperPair()), MWClass.primitiveWrapperPairs());
    }

    public static Iterator nonReferenceClasses() {
        return MWClass.primitiveClasses(MWClass.nonReferencePrimitiveWrapperPairs());
    }

    public static Iterator nonReferenceClassNames() {
        return MWClass.primitiveClassNames(MWClass.nonReferencePrimitiveWrapperPairs());
    }

    public static boolean nonReferenceClassNamesContains(String className) {
        return CollectionTools.contains(MWClass.nonReferenceClassNames(), (Object)className);
    }

    public static Iterator nonReferenceWrapperClasses() {
        return MWClass.wrapperClasses(MWClass.nonReferencePrimitiveWrapperPairs());
    }

    static {
        LEGACY_50_STUB_NULL_VALUE = Boolean.FALSE;
    }

    private static class PrimitiveWrapperPair {
        private Class primitiveClass;
        private Class wrapperClass;

        PrimitiveWrapperPair(Class primitiveClass, Class wrapperClass) {
            this.primitiveClass = primitiveClass;
            this.wrapperClass = wrapperClass;
        }

        Class getPrimitiveClass() {
            return this.primitiveClass;
        }

        Class getWrapperClass() {
            return this.wrapperClass;
        }

        String primitiveClassName() {
            return this.getPrimitiveClass().getName();
        }

        String wrapperClassName() {
            return this.getWrapperClass().getName();
        }
    }
}

