/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DatabasePlatformRepository
extends AbstractNodeModel {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private File file;
    public static final String FILE_PROPERTY = "file";
    private Collection platforms;
    public static final String PLATFORMS_COLLECTION = "platforms";
    private DatabasePlatform defaultPlatform;
    public static final String DEFAULT_PLATFORM_PROPERTY = "defaultPlatform";
    private JDBCTypeRepository jdbcTypeRepository;
    private ChangeNotifier changeNotifier;
    private Node.Validator validator;
    private Collection originalPlatformShortFileNames;
    private File originalFile;
    private static final String PLATFORMS_DIRECTORY_NAME = "platforms";
    private static final String DEFAULT_PLATFORM_REPOSITORY_FILE_NAME = "platforms.dpr";
    private static DatabasePlatformRepository defaultRepository;

    public static DatabasePlatformRepository getDefault() {
        if (defaultRepository == null) {
            defaultRepository = DatabasePlatformRepository.buildDefault();
        }
        return defaultRepository;
    }

    private static DatabasePlatformRepository buildDefault() {
        try {
            return new DatabasePlatformRepository(DatabasePlatformRepository.buildDefaultFile());
        }
        catch (CorruptXMLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static File buildDefaultFile() {
        try {
            return FileTools.resourceFile("/platforms.dpr");
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DatabasePlatformRepository(File file) throws CorruptXMLException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.read();
    }

    public DatabasePlatformRepository(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.jdbcTypeRepository = new JDBCTypeRepository(this);
        this.originalPlatformShortFileNames = Collections.EMPTY_SET;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.platforms = new Vector();
        this.changeNotifier = DefaultChangeNotifier.instance();
        this.validator = NULL_VALIDATOR;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        File old = this.file;
        this.file = file;
        this.firePropertyChanged(FILE_PROPERTY, old, file);
        if (old != null && old.exists()) {
            if (old.getParentFile().equals(file.getParentFile())) {
                if (!old.getName().equals(file.getName())) {
                    this.originalFile = old;
                }
            } else {
                this.markEntireBranchDirty();
                this.originalPlatformShortFileNames = Collections.EMPTY_SET;
            }
        }
    }

    public Iterator platforms() {
        return new CloneIterator(this.platforms){

            @Override
            protected void remove(Object current) {
                DatabasePlatformRepository.this.removePlatform((DatabasePlatform)current);
            }
        };
    }

    public int platformsSize() {
        return this.platforms.size();
    }

    public DatabasePlatform addPlatform(String platformName, String platformShortFileName) {
        this.checkPlatform(platformName, platformShortFileName);
        return this.addPlatform(new DatabasePlatform(this, platformName, platformShortFileName));
    }

    private DatabasePlatform addPlatform(DatabasePlatform platform) {
        this.addItemToCollection(platform, this.platforms, "platforms");
        this.markBranchDirty();
        if (this.defaultPlatform == null) {
            this.setDefaultPlatform(platform);
        }
        return platform;
    }

    public void removePlatform(DatabasePlatform platform) {
        this.removeItemFromCollection(platform, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public void removePlatforms(Collection pforms) {
        this.removeItemsFromCollection(pforms, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public void removePlatforms(Iterator pforms) {
        this.removeItemsFromCollection(pforms, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public DatabasePlatform getDefaultPlatform() {
        return this.defaultPlatform;
    }

    public void setDefaultPlatform(DatabasePlatform defaultPlatform) {
        if (defaultPlatform == null && this.platforms.size() > 0) {
            throw new NullPointerException();
        }
        DatabasePlatform old = this.defaultPlatform;
        this.defaultPlatform = defaultPlatform;
        this.firePropertyChanged(DEFAULT_PLATFORM_PROPERTY, old, defaultPlatform);
    }

    public JDBCTypeRepository getJDBCTypeRepository() {
        return this.jdbcTypeRepository;
    }

    @Override
    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    @Override
    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    @Override
    public Node.Validator getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    private File platformsDirectory() {
        return new File(this.file.getParentFile(), "platforms");
    }

    public DatabasePlatform platformNamed(String databasePlatformName) {
        Collection collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform platform : this.platforms) {
                if (!platform.getName().equals(databasePlatformName)) continue;
                return platform;
            }
            throw new IllegalArgumentException("missing database platform named: " + databasePlatformName);
        }
    }

    public DatabasePlatform platformForRuntimePlatformClassNamed(String runtimePlatformClassName) {
        Collection collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform platform : this.platforms) {
                if (!platform.getRuntimePlatformClassName().equals(runtimePlatformClassName)) continue;
                return platform;
            }
            throw new IllegalArgumentException("missing database platform for run-time platform class: " + runtimePlatformClassName);
        }
    }

    private Iterator platformNames() {
        return new TransformationIterator(this.platforms()){

            @Override
            protected Object transform(Object next) {
                return ((DatabasePlatform)next).getName();
            }
        };
    }

    private Iterator platformShortFileNames() {
        return new TransformationIterator(this.platforms()){

            @Override
            protected Object transform(Object next) {
                return ((DatabasePlatform)next).getShortFileName();
            }
        };
    }

    private Iterator lowerCasePlatformShortFileNames() {
        return new TransformationIterator(this.platformShortFileNames()){

            @Override
            protected Object transform(Object next) {
                return ((String)next).toLowerCase();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.platforms;
        synchronized (collection) {
            children.addAll(this.platforms);
        }
        children.add(this.jdbcTypeRepository);
    }

    @Override
    protected void addTransientAspectNamesTo(Set transientAspectNames) {
        super.addTransientAspectNamesTo(transientAspectNames);
        transientAspectNames.add("platforms");
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        if (this.platforms.isEmpty()) {
            currentProblems.add(this.buildProblem("001"));
        }
        super.addProblemsTo(currentProblems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDefaultPlatform() {
        Collection collection = this.platforms;
        synchronized (collection) {
            if (!this.platforms.contains(this.defaultPlatform)) {
                if (this.platforms.isEmpty()) {
                    this.setDefaultPlatform(null);
                } else {
                    this.setDefaultPlatform((DatabasePlatform)this.platforms.iterator().next());
                }
            }
        }
    }

    public DatabasePlatform clone(DatabasePlatform original) {
        String originalName = original.getName();
        String originalFileName = original.getShortFileName();
        String originalFileNameBase = FileTools.stripExtension(originalFileName);
        String originalFileNameExtension = FileTools.extension(originalFileName);
        DatabasePlatform clone = null;
        int cloneCount = 1;
        boolean success = false;
        while (!success) {
            String cloneName = originalName + ++cloneCount;
            String cloneFileName = originalFileNameBase + cloneCount + originalFileNameExtension;
            try {
                clone = this.addPlatform(cloneName, cloneFileName);
                success = true;
            }
            catch (IllegalArgumentException ex) {
                String msg = ex.getMessage();
                if (msg.indexOf(cloneName) != -1 || msg.indexOf(cloneFileName) != -1) continue;
                throw ex;
            }
        }
        clone.cloneFrom(original);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcTypeAdded(JDBCType addedJDBCType) {
        Collection collection = this.platforms;
        synchronized (collection) {
            Iterator stream = this.platforms.iterator();
            while (stream.hasNext()) {
                ((DatabasePlatform)stream.next()).jdbcTypeAdded(addedJDBCType);
            }
        }
    }

    private void checkPlatform(DatabasePlatform platform) {
        this.checkPlatform(platform.getName(), platform.getShortFileName());
    }

    private void checkPlatform(String platformName, String platformShortFileName) {
        this.checkPlatformName(platformName);
        this.checkPlatformShortFileName(platformShortFileName);
    }

    void checkPlatformName(String platformName) {
        if (platformName == null || platformName.length() == 0) {
            throw new IllegalArgumentException("platform name is required");
        }
        if (CollectionTools.contains(this.platformNames(), (Object)platformName)) {
            throw new IllegalArgumentException("duplicate platform name: " + platformName);
        }
    }

    void checkPlatformShortFileName(String platformShortFileName) {
        if (platformShortFileName == null || platformShortFileName.length() == 0) {
            throw new IllegalArgumentException("platform short file name is required");
        }
        if (FileTools.fileNameIsInvalid(platformShortFileName)) {
            throw new IllegalArgumentException("invalid file name: " + platformShortFileName);
        }
        if (CollectionTools.contains(this.lowerCasePlatformShortFileNames(), (Object)platformShortFileName.toLowerCase())) {
            throw new IllegalArgumentException("duplicate file name: " + platformShortFileName);
        }
    }

    private void read() throws CorruptXMLException {
        Document document = XMLTools.parse(this.file);
        Node root = XMLTools.child(document, "platforms");
        if (root == null) {
            throw this.buildCorruptXMLException("missing root node: platforms");
        }
        this.name = XMLTools.childTextContent(root, NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw this.buildCorruptXMLException("name is required");
        }
        ClassTools.setFieldValue(this, "comment", XMLTools.childTextContent(root, "comment", ""));
        this.jdbcTypeRepository = new JDBCTypeRepository(this, XMLTools.child(root, "jdbc-type-repository"));
        this.readPlatforms();
        String defaultPlatformName = XMLTools.childTextContent(root, "default-platform", null);
        if (defaultPlatformName == null || defaultPlatformName.length() == 0) {
            if (this.platforms.size() != 0) {
                throw this.buildCorruptXMLException("default platform name is required");
            }
        } else {
            if (this.platforms.size() == 0) {
                throw this.buildCorruptXMLException("default platform should not be specified when there are no platforms");
            }
            try {
                this.defaultPlatform = this.platformNamed(defaultPlatformName);
            }
            catch (IllegalArgumentException ex) {
                throw this.buildCorruptXMLException(ex);
            }
        }
        this.originalPlatformShortFileNames = CollectionTools.collection(this.platformShortFileNames());
        this.markEntireBranchClean();
    }

    private void readPlatforms() throws CorruptXMLException {
        File platformsDirectory = this.platformsDirectory();
        if (platformsDirectory.exists() && platformsDirectory.isDirectory()) {
            File[] platformFiles = platformsDirectory.listFiles();
            int i = platformFiles.length;
            while (i-- > 0) {
                this.readPlatform(platformFiles[i]);
            }
        }
    }

    private void readPlatform(File platformFile) throws CorruptXMLException {
        if (platformFile.isFile() && FileTools.extension(platformFile).toLowerCase().equals(".xml")) {
            DatabasePlatform platform = new DatabasePlatform(this, platformFile);
            try {
                this.checkPlatform(platform);
            }
            catch (IllegalArgumentException ex) {
                throw this.buildCorruptXMLException(ex);
            }
            this.platforms.add(platform);
        }
    }

    private CorruptXMLException buildCorruptXMLException(String message) {
        return new CorruptXMLException(message + " (" + this.file.getPath() + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable t) {
        return new CorruptXMLException(this.file.getPath(), t);
    }

    public void write() {
        if (this.isCleanBranch()) {
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("the repository's file must be set before it is written");
        }
        this.writePlatforms();
        if (this.isDirtyBranch()) {
            this.writeRepositoryFile();
            this.markEntireBranchClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePlatforms() {
        File platformsDirectory = this.platformsDirectory();
        if (platformsDirectory.exists()) {
            if (!platformsDirectory.isDirectory()) {
                throw new IllegalStateException("platforms directory is not a directory: " + platformsDirectory.getAbsolutePath());
            }
        } else if (!platformsDirectory.mkdirs()) {
            throw new RuntimeException("unable to create platforms directory: " + platformsDirectory.getAbsolutePath());
        }
        this.deleteOldPlatformFiles(platformsDirectory);
        Collection collection = this.platforms;
        synchronized (collection) {
            Iterator stream = this.platforms.iterator();
            while (stream.hasNext()) {
                ((DatabasePlatform)stream.next()).write(platformsDirectory);
            }
        }
    }

    private void deleteOldPlatformFiles(File platformsDirectory) {
        HashBag deletedPlatformFileNames = new HashBag(this.originalPlatformShortFileNames);
        Collection currentPlatformFileNames = CollectionTools.collection(this.platformShortFileNames());
        deletedPlatformFileNames.removeAll(currentPlatformFileNames);
        for (String fileName : deletedPlatformFileNames) {
            new File(platformsDirectory, fileName).delete();
        }
        this.originalPlatformShortFileNames = currentPlatformFileNames;
    }

    private void writeRepositoryFile() {
        Document document = XMLTools.newDocument();
        Element root = document.createElement("platforms");
        document.appendChild(root);
        XMLTools.addSimpleTextNode((Node)root, NAME_PROPERTY, this.name);
        XMLTools.addSimpleTextNode((Node)root, "comment", (String)ClassTools.getFieldValue(this, "comment"), "");
        if (this.defaultPlatform != null) {
            XMLTools.addSimpleTextNode((Node)root, "default-platform", this.defaultPlatform.getName());
        }
        this.jdbcTypeRepository.write(root.appendChild(document.createElement("jdbc-type-repository")));
        XMLTools.print(document, this.file);
        if (this.originalFile != null) {
            if (!this.originalFile.delete()) {
                throw new RuntimeException("unable to delete original file: " + this.originalFile.getPath());
            }
            this.originalFile = null;
        }
    }

    @Override
    public String displayString() {
        return this.name;
    }

    @Override
    public void toString(StringBuffer sb) {
        Iterator stream = this.platforms();
        while (stream.hasNext()) {
            DatabasePlatform platform = (DatabasePlatform)stream.next();
            platform.toString(sb);
            if (!stream.hasNext()) continue;
            sb.append(", ");
        }
    }
}

