/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariable;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LocalVariableTableAttribute
extends Attribute {
    private short count;
    private LocalVariable[] localVariables;

    LocalVariableTableAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    @Override
    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        LocalVariable[] variables = this.localVariables = new LocalVariable[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            variables[i] = new LocalVariable(stream, this.constantPool());
        }
    }

    @Override
    public void displayNameOn(IndentingPrintWriter writer) {
        super.displayNameOn(writer);
        writer.print(" (count: ");
        writer.print(this.count);
        writer.print(")");
    }

    @Override
    void displayInfoStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        LocalVariable[] variables = this.localVariables;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            variables[i].displayStringOn(writer);
        }
    }

    public String localVariableName(short index) {
        return this.localVariables[index].name();
    }

    public LocalVariable localVariableNamed(String name) {
        short cnt = this.count;
        LocalVariable[] variables = this.localVariables;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            LocalVariable localVariable = variables[i];
            if (!localVariable.isNamed(name)) continue;
            return localVariable;
        }
        return null;
    }

    public String[] localVariableNames() {
        short cnt = this.count;
        if (cnt == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] localVariableNames = new String[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localVariableNames[i] = this.localVariableName(i);
        }
        return localVariableNames;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        LocalVariable[] variables = this.localVariables;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            variables[i].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public LocalVariable[] getLocalVariables() {
        return this.localVariables;
    }

    public LocalVariable getLocalVariable(short index) {
        return this.localVariables[index];
    }

    @Override
    void toString(StringBuffer sb) {
        sb.append(this.count);
        sb.append(" local variable(s)");
    }
}

