/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class MethodPool
implements Member.Pool {
    private ClassFile classFile;
    private short count;
    private Method[] methods;

    MethodPool(ClassFileDataInputStream stream, ClassFile classFile) throws IOException {
        this.classFile = classFile;
        this.initialize(stream);
    }

    private void initialize(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        Method[] localMethods = this.methods = new Method[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localMethods[i] = new Method(stream, this);
        }
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        Method[] localMethods = this.methods;
        writer.print("Method Pool (count: ");
        writer.print(cnt);
        writer.println(')');
        writer.indent();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            localMethods[i].displayStringOn(writer);
        }
        writer.undent();
    }

    public Method[] declaredConstructors() {
        short cnt = this.count;
        Method[] localMethods = this.methods;
        ArrayList<Method> declaredConstructors = new ArrayList<Method>(cnt);
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            Method method = localMethods[i];
            if (!method.isDeclaredConstructor()) continue;
            declaredConstructors.add(method);
        }
        return declaredConstructors.toArray(new Method[declaredConstructors.size()]);
    }

    public Method[] declaredMethods() {
        short cnt = this.count;
        Method[] localMethods = this.methods;
        ArrayList<Method> declaredMethods = new ArrayList<Method>(cnt);
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            Method method = localMethods[i];
            if (!method.isDeclaredMethod()) continue;
            declaredMethods.add(method);
        }
        return declaredMethods.toArray(new Method[declaredMethods.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        Method[] localMethods = this.methods;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localMethods[i].accept(visitor);
        }
    }

    @Override
    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short getCount() {
        return this.count;
    }

    public Method get(short index) {
        return this.methods[index];
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " method(s))";
    }
}

