/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;

public class GroupBox
extends AccessibleTitledPanel {
    private static final String FILL_VERTICAL = "fillVertical";
    public static final JComponent NO_PANE = new JComponent(){};

    private GroupBox() {
        super(new GridBagLayout());
    }

    public GroupBox(AbstractButton button1, AbstractButton button2, AbstractButton button3, JComponent pane) {
        this(new AbstractButton[]{button1, button2, button3}, new JComponent[]{NO_PANE, NO_PANE, pane});
    }

    public GroupBox(AbstractButton button1, AbstractButton button2, JComponent pane) {
        this(new AbstractButton[]{button1, button2}, new JComponent[]{NO_PANE, pane});
    }

    public GroupBox(AbstractButton button, JComponent pane) {
        this(new AbstractButton[]{button}, new JComponent[]{pane});
    }

    public GroupBox(AbstractButton button1, JComponent pane1, AbstractButton button2, JComponent pane2) {
        this(new AbstractButton[]{button1, button2}, new JComponent[]{pane1, pane2});
    }

    public GroupBox(AbstractButton[] buttons, JComponent pane) {
        this(buttons, GroupBox.componentArray(buttons.length, pane));
    }

    public GroupBox(AbstractButton[] buttons, JComponent[] panes) {
        this();
        this.initializeLayout(buttons, panes);
    }

    private static JComponent[] componentArray(int length, JComponent pane) {
        Object[] components = new JComponent[length];
        Arrays.fill(components, NO_PANE);
        components[length - 1] = pane;
        return components;
    }

    public static void fillVertical(JComponent component) {
        component.putClientProperty(FILL_VERTICAL, Boolean.TRUE);
    }

    private ItemListener buildRepainterHandler() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                button.repaint();
            }
        };
    }

    private void checkIntegrity(AbstractButton[] buttons, JComponent[] panes) {
        if (buttons.length == 0) {
            throw new NullPointerException("At least one button has to be used to create a GroupBox");
        }
        if (panes.length == 0) {
            throw new NullPointerException("At least one pane has to be used to create a GroupBox");
        }
        if (buttons.length != panes.length) {
            throw new NullPointerException("The count of panes and buttons has to be the same, if no pane is associated with a button, null as to be set as for the pane");
        }
    }

    private Border createPaneBorder(AbstractButton button, JComponent pane) {
        return BorderFactory.createCompoundBorder(new AccessibleTitledBorder(button), BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGroupBox();
        }
        return this.accessibleContext;
    }

    protected void initializeLayout(AbstractButton[] buttons, JComponent[] panes) {
        this.checkIntegrity(buttons, panes);
        GridBagConstraints constraints = new GridBagConstraints();
        for (int index = 0; index < buttons.length; ++index) {
            boolean paneWasAddedBefore = index > 0 && panes[index - 1] != NO_PANE;
            AbstractButton button = buttons[index];
            button.setOpaque(false);
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), button.getBorder()));
            if (panes[index] != NO_PANE) {
                button.addItemListener(this.buildRepainterHandler());
            }
            constraints.gridx = 0;
            constraints.gridy = index;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 23;
            constraints.insets = new Insets(paneWasAddedBefore ? 5 : 0, 0, 0, 0);
            this.add((Component)button, constraints);
            JComponent pane = panes[index];
            if (pane == NO_PANE) continue;
            boolean fillVertical = this.shouldFillVertical(pane);
            int top = button.getPreferredSize().height / 2 - 6;
            pane.setBorder(BorderFactory.createCompoundBorder(this.createPaneBorder(button, pane), pane.getBorder()));
            constraints.gridx = 0;
            constraints.gridy = index;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = fillVertical ? 1.0 : 0.0;
            constraints.fill = fillVertical ? 1 : 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(paneWasAddedBefore ? top + 5 : top, 0, 0, 0);
            this.add((Component)pane, constraints);
        }
    }

    private boolean shouldFillVertical(JComponent component) {
        Boolean fillVertical = (Boolean)component.getClientProperty(FILL_VERTICAL);
        return fillVertical != null ? fillVertical : false;
    }

    private static class AccessibleTitledBorder
    extends TitledBorder {
        private AbstractButton button;

        private AccessibleTitledBorder(AbstractButton button) {
            super(button.getText());
            this.initialize(button);
        }

        private void initialize(AbstractButton button) {
            PropertyChangeListener listener = this.buildPropertyChangeListener();
            this.button = button;
            this.button.addPropertyChangeListener("font", listener);
            this.button.addPropertyChangeListener("text", listener);
        }

        private String buildWhitespaceTitle(AbstractButton button) {
            String text = button.getText();
            if (text == null) {
                text = "";
            }
            FontMetrics fontMetrics = button.getFontMetrics(button.getFont());
            int width = fontMetrics.stringWidth(text) - 5;
            int charWidth = fontMetrics.charWidth(' ');
            if (button instanceof JRadioButton) {
                width += SwingTools.radioButtonIconWidth();
            } else if (button instanceof JCheckBox) {
                width += SwingTools.checkBoxIconWidth();
            }
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < width; index += charWidth) {
                sb.append(' ');
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBaseline(Component c, int width, int height) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                int n = super.getBaseline(c, width, height);
                return n;
            }
            finally {
                this.setTitle(oldText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component.BaselineResizeBehavior getBaselineResizeBehavior(Component c) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                Component.BaselineResizeBehavior baselineResizeBehavior = super.getBaselineResizeBehavior(c);
                return baselineResizeBehavior;
            }
            finally {
                this.setTitle(oldText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                Insets insets2 = super.getBorderInsets(c, insets);
                return insets2;
            }
            finally {
                this.setTitle(oldText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Insets getBorderInsets(Component c) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                Insets insets = super.getBorderInsets(c);
                return insets;
            }
            finally {
                this.setTitle(oldText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                Rectangle rectangle = super.getInteriorRectangle(c, x, y, width, height);
                return rectangle;
            }
            finally {
                this.setTitle(oldText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension getMinimumSize(Component c) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                Dimension dimension = super.getMinimumSize(c);
                return dimension;
            }
            finally {
                this.setTitle(oldText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            String oldText = this.getTitle();
            this.setTitle(this.buildWhitespaceTitle(this.button));
            this.setTitleFont(this.button.getFont());
            try {
                super.paintBorder(c, g, x, y, width, height);
            }
            finally {
                this.setTitle(oldText);
            }
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractButton button = (AbstractButton)evt.getSource();
                    AccessibleTitledBorder.this.setTitleFont(button.getFont());
                    AccessibleTitledBorder.this.setTitle(AccessibleTitledBorder.this.buildWhitespaceTitle(button));
                }
            };
        }
    }

    protected class AccessibleGroupBox
    extends AccessibleTitledPanel.AccessibleAccessibleTitledPane {
        protected AccessibleGroupBox() {
        }
    }
}

