/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell;

import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.app.ActiveIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.SimpleIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.NoneSelectedCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWCompositeEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWRootEisDescriptor;

public class DescriptorCellRendererAdapter
extends NoneSelectedCellRendererAdapter {
    public DescriptorCellRendererAdapter(ResourceRepository repository) {
        super(repository);
    }

    @Override
    protected Icon buildNonNullValueIcon(Object value) {
        MWDescriptor descriptor = (MWDescriptor)value;
        return new ActiveIconBuilder(this.buildIconBuilder(descriptor), descriptor.isActive()).buildIcon();
    }

    private IconBuilder buildIconBuilder(MWDescriptor descriptor) {
        return new SimpleIconBuilder(this.resourceRepository().getIcon(this.buildIconKey(descriptor)));
    }

    private String buildIconKey(MWDescriptor descriptor) {
        if (descriptor instanceof MWTableDescriptor) {
            return "descriptor.class";
        }
        if (descriptor instanceof MWAggregateDescriptor) {
            return "descriptor.aggregate";
        }
        if (descriptor instanceof MWRootEisDescriptor) {
            return "descriptor.eis.root";
        }
        if (descriptor instanceof MWCompositeEisDescriptor) {
            return "descriptor.eis.composite";
        }
        if (descriptor instanceof MWOXDescriptor) {
            return "descriptor.ox";
        }
        return "descriptor.interface";
    }

    @Override
    protected String buildNonNullValueText(Object value) {
        return ((MWDescriptor)value).displayStringWithPackage();
    }

    @Override
    public String buildAccessibleName(Object value) {
        MWDescriptor descriptor = (MWDescriptor)value;
        StringBuffer sb = new StringBuffer();
        if (descriptor instanceof MWAggregateDescriptor) {
            sb.append(this.resourceRepository().getString("DESCRIPTOR_TYPE_AGGREGATE"));
        } else if (descriptor instanceof MWInterfaceDescriptor) {
            sb.append(this.resourceRepository().getString("DESCRIPTOR_TYPE_INTERFACE"));
        } else if (descriptor instanceof MWTableDescriptor) {
            sb.append(this.resourceRepository().getString("DESCRIPTOR_TYPE_RELATIONAL"));
        } else if (descriptor instanceof MWRootEisDescriptor) {
            sb.append(this.resourceRepository().getString("DESCRIPTOR_TYPE_ROOT_EIS"));
        } else if (descriptor instanceof MWCompositeEisDescriptor) {
            sb.append(this.resourceRepository().getString("DESCRIPTOR_TYPE_COMPOSITE_EIS"));
        } else if (descriptor instanceof MWOXDescriptor) {
            sb.append(this.resourceRepository().getString("DESCRIPTOR_TYPE_OX"));
        }
        sb.append(this.buildText(value));
        return sb.toString();
    }
}

