/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.PackageNameDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class MoveDescriptorAction
extends AbstractFrameworkAction {
    MoveDescriptorAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setIcon(EMPTY_ICON);
        this.initializeTextAndMnemonic("MOVE_DESCRIPTOR_ACTION");
        this.initializeToolTipText("MOVE_DESCRIPTOR_ACTION.tooltip");
    }

    @Override
    protected void execute() {
        String packageName = this.promptForPackageName(this.selectedNodes()[0]);
        if (packageName != null) {
            ApplicationNode[] selectedNodes = this.selectedNodes();
            int size = selectedNodes.length;
            TreePath[] selectionPath = new TreePath[size];
            for (int i = 0; i < size; ++i) {
                selectionPath[i] = this.renameDescriptor((DescriptorNode)selectedNodes[i], packageName);
            }
            this.navigatorSelectionModel().setSelectionPaths(selectionPath);
        }
    }

    private TreePath renameDescriptor(DescriptorNode descriptorNode, String packageName) {
        MWDescriptor descriptor = (MWDescriptor)descriptorNode.getValue();
        MWClass mwClass = descriptor.getMWClass();
        mwClass.setName(packageName + "." + mwClass.shortName());
        descriptor.setName(packageName + "." + mwClass.shortName());
        return new TreePath(descriptorNode.getProjectRoot().descendantNodeForValue((Node)descriptor).path());
    }

    private String promptForPackageName(ApplicationNode node) {
        PackageNameDialog packageNameDialog = new PackageNameDialog(this.getWorkbenchContext(), this.buildPackageNamesCollectionHolder(node));
        packageNameDialog.show();
        if (packageNameDialog.wasConfirmed()) {
            return packageNameDialog.getPackageName();
        }
        return null;
    }

    private CollectionValueModel buildPackageNamesCollectionHolder(ApplicationNode selectedNode) {
        return new SimpleCollectionValueModel(CollectionTools.collection((Iterator)((MWProject)selectedNode.getProjectRoot().getValue()).packageNames()));
    }
}

