/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class DeleteProjectAction
extends AbstractFrameworkAction {
    DeleteProjectAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        this.initializeText("DELETE_PROJECT_ACTION");
        this.initializeMnemonic("DELETE_PROJECT_ACTION");
        this.initializeToolTipText("DELETE_PROJECT_ACTION.toolTipText");
        this.initializeIcon("project.remove");
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        MWProject selectedProject = (MWProject)selectedNode.getValue();
        File saveDirectory = selectedProject.getSaveDirectory();
        File projectFile = new File(saveDirectory, selectedProject.getName() + ".mwp");
        if (projectFile.exists()) {
            if (this.confirmDeletion()) {
                this.deleteProject(selectedNode, projectFile);
            }
        } else {
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("PROJECT_FILE_DOES_NOT_EXIST.message", StringTools.CR));
            this.closeProject(selectedNode);
        }
    }

    private boolean confirmDeletion() {
        int option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("DELETE_PROJECT_WARNING.message", StringTools.CR), this.resourceRepository().getString("DELETE_PROJECT_WARNING.title"), 0, 2);
        return option == 0;
    }

    public void deleteProject(ApplicationNode projectNode, File projectFileToDelete) {
        boolean success = false;
        if (projectFileToDelete != null && projectFileToDelete.exists()) {
            int extensionIndex = projectFileToDelete.getName().lastIndexOf(46);
            String noExtensionProjectName = extensionIndex == -1 ? projectFileToDelete.getName() : projectFileToDelete.getName().substring(0, extensionIndex);
            File directory = projectFileToDelete.getParentFile();
            File[] mwpFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".mwp");
                }
            });
            if (mwpFiles.length == 1) {
                success = this.deleteProjectByFile(projectFileToDelete);
            } else {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("UNABLE_TO_DELETE_PROJECT_DIALOG.message", new Object[]{noExtensionProjectName}), this.resourceRepository().getString("UNABLE_TO_DELETE_PROJECT_DIALOG.title"), 0);
                return;
            }
        }
        if (success) {
            this.closeProject(projectNode);
        }
    }

    private void closeProject(ApplicationNode projectNode) {
        this.nodeManager().removeProjectNode(projectNode);
    }

    private boolean deleteProjectByFile(File projectFileToDelete) {
        boolean success = true;
        File directory = projectFileToDelete.getParentFile();
        projectFileToDelete.delete();
        File[] bldrDirectories = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.equals("classes") || name.equals("descriptors") || name.equals("tables") || name.equals("schemas")) && dir.isDirectory();
            }
        });
        int length = bldrDirectories.length;
        for (int i = 0; i < length && success; ++i) {
            success = this.deleteDirectory(bldrDirectories[i]);
        }
        return success;
    }

    private boolean deleteDirectory(File directory) {
        boolean successful = true;
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            int length = files.length;
            for (int i = 0; i < length && successful; ++i) {
                successful = !files[i].isDirectory() ? files[i].delete() : this.deleteDirectory(files[i]);
            }
            if (successful) {
                directory.delete();
            }
        }
        return successful;
    }
}

