/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.TransactionalDescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public final class RelationalDescriptorQueriesSettingsPage
extends ScrollablePropertiesPage {
    public RelationalDescriptorQueriesSettingsPage(PropertyValueModel relationalDescriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(relationalDescriptorNodeHolder, contextHolder);
    }

    @Override
    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
    }

    private PropertyValueModel buildQueryManagerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getQueryManager();
            }
        };
    }

    @Override
    protected Component buildPage() {
        this.setName(this.resourceRepository().getString("SETTINGS_PANEL_NAME"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)this.buildQueryTimeoutPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)TransactionalDescriptorComponentFactory.buildRefreshCachePolicyPanel(this.getSelectionHolder(), this.getApplicationContext()), constraints);
        this.addHelpTopicId(mainPanel, this.helpTopicId());
        return mainPanel;
    }

    private JPanel buildQueryTimeoutPanel() {
        JPanel queryTimeoutPanel = new JPanel(new GridBagLayout());
        queryTimeoutPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("QUERY_TIMEOUT_BORDER_LABEL")));
        GridBagConstraints constraints = new GridBagConstraints();
        JRadioButton defaultTimeoutRadioButton = this.buildDefaultQueryTimeOutRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 5, 5);
        queryTimeoutPanel.add((Component)defaultTimeoutRadioButton, constraints);
        JRadioButton noTimeoutRadioButton = this.buildNoQueryTimeOutRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 5, 5);
        queryTimeoutPanel.add((Component)noTimeoutRadioButton, constraints);
        JRadioButton queryTimeoutRadioButton = this.buildQueryTimeOutRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 5, 5);
        queryTimeoutPanel.add((Component)queryTimeoutRadioButton, constraints);
        JSpinner queryTimeoutSpinButton = SwingComponentFactory.buildSpinnerNumber(this.buildQueryTimeoutSpinnerModel());
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 5, 5);
        queryTimeoutPanel.add((Component)queryTimeoutSpinButton, constraints);
        JLabel queryTimeoutLabel = new JLabel(this.resourceRepository().getString("QUERY_TIMEOUT_SECONDS_LABEL"));
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 5, 5);
        queryTimeoutPanel.add((Component)queryTimeoutLabel, constraints);
        Component[] queryTimeoutComponents = new Component[]{queryTimeoutSpinButton, queryTimeoutLabel};
        this.buildQueryTimeoutSpinnerEnabler(this.buildQueryTimeoutHolder(), queryTimeoutComponents);
        this.helpManager().addTopicID(queryTimeoutPanel, "descriptor.queries.timeout");
        return queryTimeoutPanel;
    }

    private JRadioButton buildDefaultQueryTimeOutRadioButton() {
        return this.buildRadioButton("QUERY_SETTINGS_DEFAULT_TIMEOUT", this.buildRadioButtonModelAdapter(MWQueryManager.DEFAULT_QUERY_TIMEOUT, true));
    }

    private JRadioButton buildNoQueryTimeOutRadioButton() {
        return this.buildRadioButton("QUERY_SETTINGS_NO_TIMEOUT", this.buildRadioButtonModelAdapter(MWQueryManager.QUERY_TIMEOUT_NO_TIMEOUT, false));
    }

    private JRadioButton buildQueryTimeOutRadioButton() {
        return this.buildRadioButton("QUERY_SETTINGS_TIMEOUT", new RadioButtonModelAdapter(this.buildQueryTimeoutBooleanHolder(), Boolean.TRUE, false));
    }

    private ButtonModel buildRadioButtonModelAdapter(Integer queryTimeOut, boolean defaultValue) {
        return new RadioButtonModelAdapter(this.buildQueryTimeoutHolder(), queryTimeOut, defaultValue);
    }

    private PropertyValueModel buildQueryTimeoutHolder() {
        return new PropertyAspectAdapter(this.buildQueryManagerHolder(), "queryTimeout"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWQueryManager)this.subject).getQueryTimeout();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWQueryManager)this.subject).setQueryTimeout((Integer)value);
            }
        };
    }

    private PropertyValueModel buildQueryTimeoutBooleanHolder() {
        return new TransformationPropertyValueModel(this.buildQueryTimeoutHolder()){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return (Integer)value > 0;
            }

            @Override
            protected Object reverseTransform(Object value) {
                if (Boolean.TRUE.equals(value)) {
                    return (Integer)this.valueHolder.getValue() > 0 ? this.valueHolder.getValue() : new Integer(1);
                }
                return MWQueryManager.QUERY_TIMEOUT_NO_TIMEOUT;
            }
        };
    }

    private SpinnerNumberModel buildQueryTimeoutSpinnerModel() {
        NumberSpinnerModelAdapter spinnerNumberModel = new NumberSpinnerModelAdapter(this.buildQueryTimeoutHolder());
        spinnerNumberModel.setMinimum(new Integer(1));
        spinnerNumberModel.setMaximum(new Integer(99999));
        return spinnerNumberModel;
    }

    private ComponentEnabler buildQueryTimeoutSpinnerEnabler(PropertyValueModel queryTimeoutHolder, Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(queryTimeoutHolder){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return (Integer)value > 0;
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }

    public String helpTopicId() {
        return "descriptor.queries.settings";
    }
}

