/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionProjectlPane;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class XmlSessionProjectPane
extends AbstractSessionProjectlPane {
    XmlSessionProjectPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    private ActionListener buildEditAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlSessionProjectPane.this.edit();
            }
        };
    }

    @Override
    protected PropertyValueModel buildPrimaryProjectNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "primaryProject"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject;
                return session.getPrimaryProjectName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject;
                session.addPrimaryProjectXmlNamed((String)value);
            }
        };
    }

    @Override
    protected JButton buildEditButton() {
        JButton button = this.buildButton("SESSION_PROJECT_BROWSE_BUTTON");
        button.addActionListener(this.buildEditAction());
        return button;
    }

    private void edit() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new XmlFileFilter());
        fileChooser.setCurrentDirectory(this.retrieveLastDirectory());
        fileChooser.setFileSelectionMode(0);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject();
            File selectedFile = fileChooser.getSelectedFile();
            this.preferences().put("location", selectedFile.getParent());
            String primaryProjectXml = selectedFile.getAbsolutePath();
            if (primaryProjectXml != null) {
                primaryProjectXml = primaryProjectXml.replace('\\', '/');
            }
            session.addPrimaryProjectXmlNamed(primaryProjectXml);
        }
    }

    private File retrieveLastDirectory() {
        DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject();
        TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)session.getParent();
        File saveDirectory = topLinkSessions.getSaveDirectory();
        if (saveDirectory == null) {
            saveDirectory = FileTools.userHomeDirectory();
        }
        return new File(this.preferences().get("location", saveDirectory.getPath()));
    }

    private class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || ".xml".equalsIgnoreCase(FileTools.extension((File)file));
        }

        @Override
        public String getDescription() {
            return XmlSessionProjectPane.this.resourceRepository().getString("SESSION_PROJECT_ADVANCED_FILE_CHOOSER_DESCRIPTION");
        }
    }
}

