/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.ddlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParser;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TableDDLTestSuite {
    static DDLParser parser = null;
    static final String CREATE_TABLE_PREFIX = "CREATE TABLE ";
    static final String EMPTY_TABLE = "CREATE TABLE EMPTY_TABLE();";
    static final String DUMMY = "DUMMY";
    static final String DUMMY_TABLE = "DUMMY_TABLE ( DUMMY VARCHAR2(1) );";
    static final String DUMMY_TABLE_SCHEMA = "SCOTT.";
    static final String DUMMY_TABLE_QUOTED_SCHEMA = "\"SCOTT\".";
    static final String NORMAL = "NORMAL";
    static final String ENAME = "ENAME";
    static final String JOB = "JOB";
    static final String SAL = "SAL";
    static final String COMM = "COMM";
    static final String NORMAL_TABLE = "NORMAL (\nENAME VARCHAR2(10),\nJOB VARCHAR2(9),\nSAL NUMBER,\nCOMM NUMBER,\nCONSTRAINT \"PK_BONUS\" PRIMARY KEY (\"ENAME\", \"JOB\") ENABLE\n);";
    static final String IOT_TABLE = " FOO_IOT (\nENAME VARCHAR2(10),\nJOB VARCHAR2(9),\nSAL NUMBER,\nCOMM NUMBER,\nCONSTRAINT \"PK_BONUS\" PRIMARY KEY (\"ENAME\", \"JOB\") ENABLE\n) ORGANIZATION INDEX;";
    static final String TIMESTAMP_TABLE = "TIMESTAMP_TABLE (\nID NUMBER(10,0) NOT NULL ENABLE,\nRUN_DATE TIMESTAMP (6),\nRAW_RESULT BLOB,\nANALYSIS_ID NUMBER(10,0),\nPRIMARY KEY (ID) ENABLE\n);";
    static final String CONSTRAINTs_TABLE = "CONSTRAINT_TABLE (\nEMPLOYEE_ID NUMBER(6) NOT NULL,\nSALARY NUMBER(8,2),\nEMAIL VARCHAR2(25) CONSTRAINT \"EMP_EMAIL_NN\" NOT NULL ENABLE,\nCONSTRAINT \"EMP_EMP_ID_PK\" PRIMARY KEY (EMPLOYEE_ID) ENABLE,\n\nCONSTRAINT \"EMP_EMAIL_UK\" UNIQUE (EMAIL) ENABLE,\nCONSTRAINT \"EMP_SALARY_MIN\" CHECK (SALARY > 0) ENABLE);";
    static final String TABLE_W_KEYWORDS = "KEYWORD_TABLE";
    static final String CREATE_TABLE_W_KEYWORDS = "CREATE TABLE KEYWORD_TABLE ( \nID NUMBER(10,0) NOT NULL ENABLE,\nTIMESTAMP TIMESTAMP (6),\nRAW_RESULT BLOB,\nANALYSIS_ID NUMBER(10,0));";

    @BeforeClass
    public static void setUp() {
        parser = new DDLParser(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        parser.setTypesRepository(new DatabaseTypesRepository());
    }

    @Test
    public void testEmptyTable() {
        parser.ReInit(new StringReader(EMPTY_TABLE));
        boolean worked = true;
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            worked = false;
        }
        Assert.assertFalse((String)"empty table should not parse", (boolean)worked);
    }

    @Test
    public void testDummyTable() {
        parser.ReInit(new StringReader("CREATE TABLE DUMMY_TABLE ( DUMMY VARCHAR2(1) );"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("dummy table did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(tableType);
        Assert.assertTrue((String)"dummy table should not contain any unresolved column datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        List<FieldType> columns = tableType.getColumns();
        Assert.assertEquals((String)"dummy table has wrong number of columns", (long)1L, (long)columns.size());
        FieldType col1 = columns.get(0);
        Assert.assertEquals((String)"incorrect name for DUMMY column", (Object)DUMMY, (Object)col1.getFieldName());
        Assert.assertEquals((String)"incorrect type for DUMMY column", (Object)new VarChar2Type().getTypeName(), (Object)col1.getTypeName());
    }

    @Test
    public void testDummyTable_WithSchema() {
        parser.ReInit(new StringReader("CREATE TABLE SCOTT.DUMMY_TABLE ( DUMMY VARCHAR2(1) );"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("dummy table did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(tableType);
        Assert.assertTrue((String)"dummy table should not contain any unresolved column datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"dummy table wrong schema", (Object)DUMMY_TABLE_SCHEMA.subSequence(0, DUMMY_TABLE_SCHEMA.length() - 1), (Object)tableType.getSchema());
    }

    @Test
    public void testDummyTable_WithQuotedSchema() {
        parser.ReInit(new StringReader("CREATE TABLE \"SCOTT\".DUMMY_TABLE ( DUMMY VARCHAR2(1) );"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("dummy table did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(tableType);
        Assert.assertTrue((String)"dummy table should not contain any unresolved column datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        Assert.assertEquals((String)"dummy table wrong schema", (Object)DUMMY_TABLE_SCHEMA.subSequence(0, DUMMY_TABLE_SCHEMA.length() - 1), (Object)tableType.getSchema());
    }

    @Test
    public void testNormalTable() {
        parser.ReInit(new StringReader("CREATE TABLE NORMAL (\nENAME VARCHAR2(10),\nJOB VARCHAR2(9),\nSAL NUMBER,\nCOMM NUMBER,\nCONSTRAINT \"PK_BONUS\" PRIMARY KEY (\"ENAME\", \"JOB\") ENABLE\n);"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("NORMAL table did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(tableType);
        Assert.assertTrue((String)"NORMAL table should not contain any unresolved column datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        List<FieldType> columns = tableType.getColumns();
        Assert.assertEquals((String)"NORMAL table has wrong number of columns", (long)4L, (long)columns.size());
        FieldType col1 = columns.get(0);
        Assert.assertEquals((String)"incorrect name for ENAME column", (Object)ENAME, (Object)col1.getFieldName());
        Assert.assertEquals((String)"incorrect type for ENAME column", (Object)new VarChar2Type().getTypeName(), (Object)col1.getTypeName());
        FieldType col2 = columns.get(1);
        Assert.assertEquals((String)"incorrect name for JOB column", (Object)JOB, (Object)col2.getFieldName());
        Assert.assertEquals((String)"incorrect type for JOB column", (Object)new VarChar2Type().getTypeName(), (Object)col2.getTypeName());
        FieldType col3 = columns.get(2);
        Assert.assertEquals((String)"incorrect name for SAL column", (Object)SAL, (Object)col3.getFieldName());
        Assert.assertEquals((String)"incorrect type for SAL column", (Object)new NumericType().getTypeName(), (Object)col3.getTypeName());
        FieldType col4 = columns.get(3);
        Assert.assertEquals((String)"incorrect name for COMM column", (Object)COMM, (Object)col4.getFieldName());
        Assert.assertEquals((String)"incorrect type for COMM column", (Object)new NumericType().getTypeName(), (Object)col4.getTypeName());
    }

    @Test
    public void testIOTTable() {
        parser.ReInit(new StringReader("CREATE TABLE  FOO_IOT (\nENAME VARCHAR2(10),\nJOB VARCHAR2(9),\nSAL NUMBER,\nCOMM NUMBER,\nCONSTRAINT \"PK_BONUS\" PRIMARY KEY (\"ENAME\", \"JOB\") ENABLE\n) ORGANIZATION INDEX;"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("iot table did not parse:\n" + message), (boolean)worked);
        UnresolvedTypesVisitor l = new UnresolvedTypesVisitor();
        l.visit(tableType);
        Assert.assertTrue((String)"iot table should not contain any unresolved column datatypes", (boolean)l.getUnresolvedTypes().isEmpty());
        List<FieldType> columns = tableType.getColumns();
        Assert.assertEquals((String)"NORMAL table has wrong number of columns", (long)4L, (long)columns.size());
        FieldType col1 = columns.get(0);
        Assert.assertEquals((String)"incorrect name for ENAME column", (Object)ENAME, (Object)col1.getFieldName());
        Assert.assertEquals((String)"incorrect type for ENAME column", (Object)new VarChar2Type().getTypeName(), (Object)col1.getTypeName());
        FieldType col2 = columns.get(1);
        Assert.assertEquals((String)"incorrect name for JOB column", (Object)JOB, (Object)col2.getFieldName());
        Assert.assertEquals((String)"incorrect type for JOB column", (Object)new VarChar2Type().getTypeName(), (Object)col2.getTypeName());
        FieldType col3 = columns.get(2);
        Assert.assertEquals((String)"incorrect name for SAL column", (Object)SAL, (Object)col3.getFieldName());
        Assert.assertEquals((String)"incorrect type for SAL column", (Object)new NumericType().getTypeName(), (Object)col3.getTypeName());
        FieldType col4 = columns.get(3);
        Assert.assertEquals((String)"incorrect name for COMM column", (Object)COMM, (Object)col4.getFieldName());
        Assert.assertEquals((String)"incorrect type for COMM column", (Object)new NumericType().getTypeName(), (Object)col4.getTypeName());
    }

    @Test
    public void testTimestampTable() {
        parser.ReInit(new StringReader("CREATE TABLE TIMESTAMP_TABLE (\nID NUMBER(10,0) NOT NULL ENABLE,\nRUN_DATE TIMESTAMP (6),\nRAW_RESULT BLOB,\nANALYSIS_ID NUMBER(10,0),\nPRIMARY KEY (ID) ENABLE\n);"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("timestamp table did not parse:\n" + message), (boolean)worked);
    }

    @Test
    public void testAdditionalTableConstrainst() {
        parser.ReInit(new StringReader("CREATE TABLE CONSTRAINT_TABLE (\nEMPLOYEE_ID NUMBER(6) NOT NULL,\nSALARY NUMBER(8,2),\nEMAIL VARCHAR2(25) CONSTRAINT \"EMP_EMAIL_NN\" NOT NULL ENABLE,\nCONSTRAINT \"EMP_EMP_ID_PK\" PRIMARY KEY (EMPLOYEE_ID) ENABLE,\n\nCONSTRAINT \"EMP_EMAIL_UK\" UNIQUE (EMAIL) ENABLE,\nCONSTRAINT \"EMP_SALARY_MIN\" CHECK (SALARY > 0) ENABLE);"));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("constraints table did not parse:\n" + message), (boolean)worked);
    }

    @Test
    public void testKeywordTable() {
        parser.ReInit(new StringReader(CREATE_TABLE_W_KEYWORDS));
        boolean worked = true;
        String message = "";
        TableType tableType = null;
        try {
            tableType = parser.parseTable();
        }
        catch (ParseException pe) {
            message = pe.getMessage();
            worked = false;
        }
        Assert.assertTrue((String)("keyword table did not parse:\n" + message), (boolean)worked);
        Assert.assertEquals((String)"incorrect table name for KEYWORD_TABLE", (Object)TABLE_W_KEYWORDS, (Object)tableType.getTableName());
    }
}

