/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.documentpreservation.NodeOrderingPolicy;
import org.eclipse.persistence.oxm.documentpreservation.RelativePositionOrderingPolicy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class JAXBBinder
extends Binder {
    private XMLContext xmlContext;
    private XMLBinder xmlBinder;

    public JAXBBinder(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
        this.xmlBinder = this.xmlContext.createBinder();
        this.xmlBinder.getDocumentPreservationPolicy().setNodeOrderingPolicy((NodeOrderingPolicy)new RelativePositionOrderingPolicy());
        this.xmlBinder.setErrorHandler((ErrorHandler)new JAXBErrorHandler(JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER));
    }

    public void marshal(Object obj, Object xmlNode) throws MarshalException {
        if (obj == null || xmlNode == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (obj instanceof JAXBElement) {
                JAXBElement jaxbElem = (JAXBElement)obj;
                XMLRoot xmlRoot = new XMLRoot();
                xmlRoot.setObject(jaxbElem.getValue());
                xmlRoot.setLocalName(jaxbElem.getName().getLocalPart());
                xmlRoot.setNamespaceURI(jaxbElem.getName().getNamespaceURI());
                this.xmlBinder.marshal((Object)xmlRoot, (Node)xmlNode);
            } else {
                this.xmlBinder.marshal(obj, (Node)xmlNode);
            }
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public Object unmarshal(Object obj) throws JAXBException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object returnValue = this.xmlBinder.unmarshal((Node)obj);
            if (returnValue instanceof XMLRoot) {
                XMLRoot xmlRoot = (XMLRoot)returnValue;
                if (xmlRoot.getObject() instanceof JAXBElement) {
                    return xmlRoot.getObject();
                }
                return new JAXBElement(new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName()), xmlRoot.getObject().getClass(), xmlRoot.getObject());
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public JAXBElement unmarshal(Object obj, Class javaClass) throws JAXBException {
        if (obj == null || javaClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            XMLRoot xmlRoot = this.xmlBinder.unmarshal((Node)obj, javaClass);
            return new JAXBElement(new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName()), javaClass, xmlRoot.getObject());
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object getXMLNode(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof JAXBElement && !(obj instanceof WrappedValue)) {
            return this.xmlBinder.getXMLNode(((JAXBElement)obj).getValue());
        }
        return this.xmlBinder.getXMLNode(obj);
    }

    public Object updateXML(Object obj) {
        return this.updateXML(obj, this.getXMLNode(obj));
    }

    public Object updateXML(Object obj, Object xmlNode) {
        if (obj == null || xmlNode == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof JAXBElement && !(obj instanceof WrappedValue)) {
            obj = ((JAXBElement)obj).getValue();
        }
        this.xmlBinder.updateXML(obj, (Node)((Element)xmlNode));
        return xmlNode;
    }

    public Object getJAXBNode(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        return this.xmlBinder.getObject((Node)obj);
    }

    public Object updateJAXB(Object obj) throws JAXBException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.xmlBinder.updateObject((Node)obj);
            Object updatedObj = this.xmlBinder.getObject((Node)obj);
            boolean shouldWrapInJAXBElement = true;
            XMLDescriptor desc = (XMLDescriptor)this.xmlBinder.getMarshaller().getXMLContext().getSession(0).getClassDescriptor(updatedObj);
            if (desc == null) {
                return updatedObj;
            }
            String objRootElem = desc.getDefaultRootElement();
            if (!desc.isResultAlwaysXMLRoot() && objRootElem != null) {
                String rootElemNS = objRootElem.substring(0, objRootElem.lastIndexOf(":"));
                String rootElemName = objRootElem.substring(objRootElem.lastIndexOf(":") + 1);
                String resolvedNS = desc.getNamespaceResolver().resolveNamespacePrefix(rootElemNS);
                String nodeName = ((Node)obj).getLocalName();
                String nodeNS = ((Node)obj).getNamespaceURI();
                if (rootElemName.equals(nodeName) && resolvedNS.equals(nodeNS)) {
                    shouldWrapInJAXBElement = false;
                }
            }
            if (!shouldWrapInJAXBElement) {
                return updatedObj;
            }
            QName qname = new QName(((Node)obj).getNamespaceURI(), ((Node)obj).getLocalName());
            return new JAXBElement(qname, updatedObj.getClass(), updatedObj);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public void setSchema(Schema schema) {
        this.xmlBinder.setSchema(schema);
    }

    public Schema getSchema() {
        return this.xmlBinder.getSchema();
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        if (newValidationEventHandler == null) {
            this.xmlBinder.setErrorHandler((ErrorHandler)new JAXBErrorHandler(JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER));
        } else {
            this.xmlBinder.setErrorHandler((ErrorHandler)new JAXBErrorHandler(newValidationEventHandler));
        }
    }

    public ValidationEventHandler getEventHandler() {
        JAXBErrorHandler jaxbErrorHandler = (JAXBErrorHandler)this.xmlBinder.getErrorHandler();
        return jaxbErrorHandler.getValidationEventHandler();
    }

    public Object getProperty(String propName) throws PropertyException {
        if (propName == null) {
            throw new IllegalArgumentException();
        }
        if (propName.equals("jaxb.encoding")) {
            return this.xmlBinder.getMarshaller().getEncoding();
        }
        if (propName.equals("jaxb.formatted.output")) {
            return this.xmlBinder.getMarshaller().isFormattedOutput();
        }
        if (propName.equals("jaxb.fragment")) {
            return this.xmlBinder.getMarshaller().isFragment();
        }
        if (propName.equals("jaxb.schemaLocation")) {
            return this.xmlBinder.getMarshaller().getSchemaLocation();
        }
        if (propName.equals("jaxb.noNamespaceSchemaLocation")) {
            return this.xmlBinder.getMarshaller().getNoNamespaceSchemaLocation();
        }
        throw new PropertyException(propName);
    }

    public void setProperty(String propName, Object value) throws PropertyException {
        String valueString;
        if (propName == null) {
            throw new IllegalArgumentException(propName);
        }
        String string = valueString = value == null ? null : value.toString();
        if (propName.equals("jaxb.encoding")) {
            this.xmlBinder.getMarshaller().setEncoding(valueString);
            return;
        }
        if (propName.equals("jaxb.formatted.output")) {
            this.xmlBinder.getMarshaller().setFormattedOutput(Boolean.valueOf(valueString).booleanValue());
            return;
        }
        if (propName.equals("jaxb.fragment")) {
            this.xmlBinder.getMarshaller().setFragment(Boolean.valueOf(valueString).booleanValue());
            return;
        }
        if (propName.equals("jaxb.schemaLocation")) {
            this.xmlBinder.getMarshaller().setSchemaLocation(valueString);
            return;
        }
        if (propName.equals("jaxb.noNamespaceSchemaLocation")) {
            this.xmlBinder.getMarshaller().setNoNamespaceSchemaLocation(valueString);
            return;
        }
        throw new PropertyException(propName);
    }

    public XMLBinder getXMLBinder() {
        return this.xmlBinder;
    }
}

