/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.events;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class EmailAccount {
    public String owner;
    public String emailAddress;
    public String hostName;
    public Number id;
    public boolean preInsertExecuted;
    public boolean postInsertExecuted;
    public boolean preUpdateExecuted;
    public boolean postUpdateExecuted;
    public boolean preDeleteExecuted;
    public boolean postDeleteExecuted;
    public boolean preWriteExecuted;
    public boolean postWriteExecuted;
    public boolean postBuildExecuted;
    public boolean postRefreshExecuted;
    public boolean postMergeExecuted;
    public boolean postCloneExecuted;
    public boolean aboutToInsertExecuted;
    public boolean aboutToUpdateExecuted;
    public boolean aboutToDeleteExecuted;

    public EmailAccount() {
        this.resetFlags();
    }

    public EmailAccount(String newEmailAddress, String newOwner, String newHostName) {
        this.setEmailAddress(newEmailAddress);
        this.setOwner(newOwner);
        this.setHostName(newHostName);
        this.resetFlags();
    }

    public void aboutToInsertMethod(DescriptorEvent event) {
        this.aboutToInsertExecuted = true;
    }

    public void aboutToUpdateMethod(DescriptorEvent event) {
        this.aboutToUpdateExecuted = true;
    }

    public void aboutToDeleteMethod(DescriptorEvent event) {
        this.aboutToDeleteExecuted = true;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmailAccount.class);
        descriptor.setTableName("EMAILACC");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.addDirectMapping("id", "ID");
        descriptor.addDirectMapping("emailAddress", "EMAILADD");
        descriptor.addDirectMapping("owner", "OWNER");
        descriptor.addDirectMapping("hostName", "HOSTNAME");
        return descriptor;
    }

    public static EmailAccount example1() {
        return new EmailAccount("tedt@geocities.com", "Ted Turner", "mail.geocities.com");
    }

    public static EmailAccount example2() {
        return new EmailAccount("billd@freemail.com", "Bill Dullmar", "mail.freemail.com");
    }

    public static EmailAccount example3() {
        return new EmailAccount("taniad@freemail.com", "Tania Davidson", "mail.freemail.com");
    }

    private String getEmailAddress() {
        return this.emailAddress;
    }

    private String getHostName() {
        return this.hostName;
    }

    private String getOwner() {
        return this.owner;
    }

    public void postBuildMethod(DescriptorEvent event) {
        this.postBuildExecuted = true;
    }

    public void postCloneMethod(DescriptorEvent event) {
        this.postCloneExecuted = true;
    }

    public void postDeleteMethod(DescriptorEvent event) {
        this.postDeleteExecuted = true;
    }

    public void postInsertMethod(DescriptorEvent event) {
        this.postInsertExecuted = true;
    }

    public void postMergeMethod(DescriptorEvent event) {
        this.postMergeExecuted = true;
    }

    public void postRefreshMethod(DescriptorEvent event) {
        this.postRefreshExecuted = true;
    }

    public void postUpdateMethod(DescriptorEvent event) {
        this.postUpdateExecuted = true;
    }

    public void postWriteMethod(DescriptorEvent event) {
        this.postWriteExecuted = true;
    }

    public void preDeleteMethod(DescriptorEvent event) {
        this.preDeleteExecuted = true;
    }

    public void preInsertMethod(DescriptorEvent event) {
        this.preInsertExecuted = true;
    }

    public void preUpdateMethod(DescriptorEvent event) {
        this.preUpdateExecuted = true;
    }

    public void preWriteMethod(DescriptorEvent event) {
        this.preWriteExecuted = true;
    }

    public void resetFlags() {
        this.preInsertExecuted = false;
        this.postInsertExecuted = false;
        this.preUpdateExecuted = false;
        this.postUpdateExecuted = false;
        this.preDeleteExecuted = false;
        this.postDeleteExecuted = false;
        this.preWriteExecuted = false;
        this.postWriteExecuted = false;
        this.postBuildExecuted = false;
        this.aboutToInsertExecuted = false;
        this.aboutToUpdateExecuted = false;
        this.aboutToDeleteExecuted = false;
        this.postCloneExecuted = false;
        this.postMergeExecuted = false;
        this.postRefreshExecuted = false;
    }

    private void setEmailAddress(String newEmailAddress) {
        this.emailAddress = newEmailAddress;
    }

    public void setHostName(String newHostName) {
        this.hostName = newHostName;
    }

    private void setOwner(String newOwner) {
        this.owner = newOwner;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("EMAILACC");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("EMAILADD", String.class, 40);
        definition.addField("OWNER", String.class, 20);
        definition.addField("HOSTNAME", String.class, 20);
        return definition;
    }

    public String toString() {
        return "EmailAccount(" + this.getEmailAddress() + ")";
    }
}

