/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.ownership;

import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.ownership.ObjectA;
import org.eclipse.persistence.testing.models.ownership.ObjectB;
import org.eclipse.persistence.testing.models.ownership.ObjectC;
import org.eclipse.persistence.testing.models.ownership.ObjectD;
import org.eclipse.persistence.testing.models.ownership.ObjectE;
import org.eclipse.persistence.testing.models.ownership.OwnershipProject;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class OwnershipSystem
extends TestSystem {
    public OwnershipSystem() {
        this.project = new OwnershipProject();
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = new OwnershipProject();
        }
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        boolean supportsAlterTableConstraints;
        DatabasePlatform platform = (DatabasePlatform)session.getDatasourcePlatform();
        boolean bl = supportsAlterTableConstraints = platform.supportsForeignKeyConstraints() || platform.supportsUniqueColumns() && !platform.requiresUniqueConstraintCreationOnTableCreate();
        if (supportsAlterTableConstraints) {
            try {
                session.executeNonSelectingSQL("Alter TABLE OBJECT_A DROP CONSTRAINT OWNER_A_ONE_TO_ONE_");
                session.executeNonSelectingSQL("Alter TABLE OBJECT_C DROP CONSTRAINT OWNER_C_ONE_TO_ONE_");
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        SchemaManager schemaManager = new SchemaManager(session);
        if (supportsAlterTableConstraints) {
            schemaManager.dropConstraints(ObjectA.tableDefinition());
            schemaManager.dropConstraints(ObjectB.tableDefinition());
            schemaManager.dropConstraints(ObjectC.tableDefinition());
            schemaManager.dropConstraints(ObjectD.tableDefinition());
            schemaManager.dropConstraints(ObjectE.tableDefinition());
        }
        schemaManager.replaceObject((DatabaseObjectDefinition)ObjectA.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ObjectB.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ObjectC.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ObjectD.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ObjectE.tableDefinition());
        if (supportsAlterTableConstraints) {
            schemaManager.createConstraints(ObjectA.tableDefinition());
            schemaManager.createConstraints(ObjectB.tableDefinition());
            schemaManager.createConstraints(ObjectC.tableDefinition());
            schemaManager.createConstraints(ObjectD.tableDefinition());
            schemaManager.createConstraints(ObjectE.tableDefinition());
        }
        schemaManager.createSequences();
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        ObjectA instance = ObjectA.example1();
        session.writeObject((Object)instance);
        manager.registerObject((Object)instance, "example1");
        instance = ObjectA.example2();
        session.writeObject((Object)instance);
        manager.registerObject((Object)instance, "example2");
        instance = ObjectA.example3();
        session.writeObject((Object)instance);
        manager.registerObject((Object)instance, "example3");
    }
}

