/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.io.StringWriter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class CustomSequenceTest
extends AutoVerifyTestCase {
    private Sequence originalSequence;
    private String newSeqTableName;
    private int initialSeqCount;
    private Employee newEmployee;

    public CustomSequenceTest() {
        this.setDescription("This test verifies that sequencing can be customized using setUpdateSequenceQuery(DataModifyQuery) and setSelectSequenceNumberQuery(ValueReadQuery).");
    }

    protected void buildNEW_SEQUENCETable() {
        TableDefinition tabledefinition = new TableDefinition();
        tabledefinition.setName(this.newSeqTableName);
        FieldDefinition field = new FieldDefinition();
        field.setName("SEQ_NAME");
        field.setType(String.class);
        field.setSize(50);
        field.setShouldAllowNull(true);
        field.setIsPrimaryKey(false);
        field.setUnique(false);
        field.setIsIdentity(false);
        tabledefinition.addField(field);
        FieldDefinition field1 = new FieldDefinition();
        field1.setName("SEQ_COUNT");
        field1.setType(Long.class);
        field1.setSize(15);
        field1.setShouldAllowNull(true);
        field1.setIsPrimaryKey(false);
        field1.setUnique(false);
        field1.setIsIdentity(false);
        tabledefinition.addField(field1);
        new SchemaManager((DatabaseSession)this.getSession()).replaceObject((DatabaseObjectDefinition)tabledefinition);
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().getProject().getLogin().setDefaultSequence(this.originalSequence);
        ((DatabaseSession)this.getSession()).getSequencingControl().initializePreallocated();
    }

    public void setup() {
        DatabasePlatform p = this.getSession().getProject().getLogin().getPlatform();
        this.newSeqTableName = new String("NEW_SEQUENCE");
        this.initialSeqCount = 1233;
        this.buildNEW_SEQUENCETable();
        this.getSession().executeNonSelectingCall((Call)new SQLCall("INSERT INTO " + this.newSeqTableName + "(" + p.getSequenceNameFieldName() + ", " + p.getSequenceCounterFieldName() + ") values ('EMP_SEQ', " + this.initialSeqCount + ")"));
        this.originalSequence = this.getSession().getLogin().getDefaultSequence();
        DataModifyQuery newUpdateSeqQuery = new DataModifyQuery();
        newUpdateSeqQuery.addArgument("seqName");
        StringWriter writer1 = new StringWriter();
        writer1.write("UPDATE " + this.newSeqTableName);
        writer1.write(" SET " + p.getSequenceCounterFieldName());
        writer1.write(" = " + p.getSequenceCounterFieldName());
        writer1.write(" + " + p.getSequencePreallocationSize());
        writer1.write(" WHERE " + p.getSequenceNameFieldName());
        writer1.write(" = #seqName");
        newUpdateSeqQuery.setSQLString(writer1.toString());
        ValueReadQuery newSelectSeqNumQuery = new ValueReadQuery();
        newSelectSeqNumQuery.addArgument("seqName");
        StringWriter writer2 = new StringWriter();
        writer2.write("SELECT " + p.getSequenceCounterFieldName());
        writer2.write(" FROM " + this.newSeqTableName);
        writer2.write(" WHERE " + p.getSequenceNameFieldName());
        writer2.write(" = #seqName");
        newSelectSeqNumQuery.setSQLString(writer2.toString());
        QuerySequence newSequence = new QuerySequence();
        newSequence.setUpdateQuery(newUpdateSeqQuery);
        newSequence.setSelectQuery(newSelectSeqNumQuery);
        this.getSession().getLogin().setDefaultSequence((Sequence)newSequence);
        ((DatabaseSession)this.getSession()).getSequencingControl().resetSequencing();
        ((DatabaseSession)this.getSession()).getSequencingControl().initializePreallocated();
    }

    public void test() {
        this.beginTransaction();
        this.newEmployee = new Employee();
        this.newEmployee.setFirstName("Brendan");
        this.newEmployee.setLastName("Rickey");
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        uow1.registerObject((Object)this.newEmployee);
        uow1.commit();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        Employee empRead = (Employee)uow2.readObject((Object)this.newEmployee);
        empRead.setFirstName("Object");
        empRead.setLastName("People");
        uow2.commit();
    }

    public void verify() {
        Employee verifyEmp = (Employee)this.getSession().readObject((Object)this.newEmployee);
        if (verifyEmp.getId().intValue() != this.initialSeqCount + 1) {
            throw new TestErrorException("The new Sequence Table was not used! " + verifyEmp.getId());
        }
    }
}

