/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.flashback;

import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.AsOfSCNClause;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestAdapter;
import org.eclipse.persistence.testing.framework.TestCase;

public class HistoricalSessionTest
extends TestAdapter {
    public AsOfClause asOfClause;
    protected Session oldSession;

    public HistoricalSessionTest(AutoVerifyTestCase wrappedTest) {
        this(wrappedTest, AsOfClause.NO_CLAUSE);
    }

    public HistoricalSessionTest(AutoVerifyTestCase wrappedTest, Number systemChangeNumber) {
        this(wrappedTest, (AsOfClause)new AsOfSCNClause(systemChangeNumber));
    }

    public HistoricalSessionTest(AutoVerifyTestCase wrappedTest, AsOfClause asOfClause) {
        super((TestCase)wrappedTest);
        this.asOfClause = asOfClause;
        this.setDescription("Using HistoricalSession: " + wrappedTest.getDescription());
    }

    protected void setup() throws Exception {
        this.oldSession = this.getSession();
        this.getExecutor().setSession(this.getSession().acquireHistoricalSession(this.asOfClause));
    }

    public void reset() {
        Session currentSession = this.getSession();
        this.getExecutor().setSession(this.oldSession);
        currentSession.release();
    }
}

