/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;

public class ExclusiveConnectionClosedExceptionTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected ServerSession server;
    protected int numAcquireExclusive;
    protected int numReleaseExclusive;
    protected String errorMsg = "";
    Listener listener = new Listener();
    protected Vector emps;

    public ExclusiveConnectionClosedExceptionTest() {
        this.setDescription("This test will verify that when indirection is triggered after the session is released callbacks are called and connection released. Exception is no longer thrown.");
    }

    public void copyDescriptors(Session session) {
        Vector descriptors = new Vector();
        Iterator iterator = session.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            descriptors.addElement(iterator.next());
        }
        this.server.addDescriptors(descriptors);
        this.server.getProject().setHasIsolatedClasses(true);
    }

    public void reset() {
        try {
            this.errorMsg = "";
            this.numAcquireExclusive = 0;
            this.numReleaseExclusive = 0;
            this.server.getEventManager().removeListener((SessionEventListener)this.listener);
            this.server.logout();
            this.getDatabaseSession().logout();
            this.getDatabaseSession().login();
            String schemaName = this.getSession().getLogin().getUserName();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    public void setup() {
        try {
            this.emps = this.getSession().readAllObjects(IsolatedEmployee.class);
            String schemaName = this.getSession().getLogin().getUserName();
            this.login = (DatabaseLogin)this.getSession().getLogin().clone();
            this.server = new ServerSession((Login)this.login, 2, 5);
            this.server.getDefaultConnectionPolicy().setExclusiveMode(ConnectionPolicy.ExclusiveMode.Isolated);
            this.server.setSessionLog(this.getSession().getSessionLog());
            this.copyDescriptors(this.getSession());
            this.server.getEventManager().addListener((SessionEventListener)this.listener);
            this.server.login();
        }
        catch (RuntimeException ex) {
            this.getSession().logMessage("This test requires that the connected user has privleges to \"Creat any context\", \"Drop any context\" and \"execute Sys.DBMS_RLS package\" and \"execute Sys.DBMS_SESSION package\".");
            throw ex;
        }
    }

    public void test() {
        ReadObjectQuery query = new ReadObjectQuery(IsolatedEmployee.class);
        ClientSession client1 = this.server.acquireClientSession();
        IsolatedEmployee employee = (IsolatedEmployee)client1.executeQuery((DatabaseQuery)query);
        if (this.numAcquireExclusive != 1 || this.numReleaseExclusive != 0) {
            this.errorMsg = this.errorMsg + "After executing query numAcquireExclusive == " + this.numAcquireExclusive + " and numReleaseExclusive = " + this.numReleaseExclusive + "; 1 and 0 were expected.\n";
        }
        client1.release();
        if (this.numAcquireExclusive != 1 || this.numReleaseExclusive != 1) {
            this.errorMsg = this.errorMsg + "After releasing ExclusiveIsolatedClientSession numAcquireExclusive == " + this.numAcquireExclusive + " and numReleaseExclusive = " + this.numReleaseExclusive + "; 1 and 1 were expected.\n";
        }
        if (client1.getWriteConnection() != null) {
            this.errorMsg = this.errorMsg + "After releasing ExclusiveIsolatedClientSession its writeConnection is not null.\n";
        }
        employee.getPhoneNumbers();
        if (this.numAcquireExclusive != 2 || this.numReleaseExclusive != 2) {
            this.errorMsg = this.errorMsg + "After instantiating ValueHolder on released ExclusiveIsolatedClientSession numAcquireExclusive == " + this.numAcquireExclusive + " and numReleaseExclusive = " + this.numReleaseExclusive + "; 2 and 2 were expected.\n";
        }
        if (client1.getWriteConnection() != null) {
            this.errorMsg = this.errorMsg + "After instantiating ValueHolder on released ExclusiveIsolatedClientSession its writeConnection is not null.\n";
        }
    }

    public void verify() {
        if (this.errorMsg.length() > 0) {
            throw new TestErrorException(this.errorMsg);
        }
    }

    class Listener
    extends SessionEventAdapter {
        Listener() {
        }

        public void postAcquireExclusiveConnection(SessionEvent event) {
            ++ExclusiveConnectionClosedExceptionTest.this.numAcquireExclusive;
            event.getSession().executeNonSelectingSQL("UPDATE ISOLATED_EMPLOYEE SET F_NAME = 'A' WHERE EMP_ID = 0");
        }

        public void preReleaseExclusiveConnection(SessionEvent event) {
            ++ExclusiveConnectionClosedExceptionTest.this.numReleaseExclusive;
            event.getSession().executeNonSelectingSQL("UPDATE EMPLOYEE SET F_NAME = 'A' WHERE EMP_ID = 0");
        }
    }
}

