/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.nondeferredwrites;

import java.io.File;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class ProjectXMLTest
extends AutoVerifyTestCase {
    public static String PROJECT_FILE = "org/eclipse/persistence/testing/workbench_integration/MWIntegrationTestEmployeeProject.xml";
    public CMPPolicy oldPolicy;
    public Project employeeProject;

    public ProjectXMLTest() {
        this.setDescription("This test will verify that the isolation setting is set within the project xml");
    }

    public void setup() {
        this.employeeProject = new EmployeeProject();
        ClassDescriptor descriptor = this.employeeProject.getDescriptor(Employee.class);
        this.oldPolicy = descriptor.getCMPPolicy();
        descriptor.setCMPPolicy(new CMPPolicy());
    }

    public void test() {
        ClassDescriptor descriptor = this.employeeProject.getDescriptor(Employee.class);
        descriptor.getCMPPolicy().setDeferModificationsUntilCommit(0);
        descriptor.getCMPPolicy().setNonDeferredCreateTime(1);
        XMLProjectWriter.write((String)"NonDeferredProject.xml", (Project)this.employeeProject);
        Project project = XMLProjectReader.read((String)"NonDeferredProject.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        if (project.getDescriptor(Employee.class).getCMPPolicy().getDeferModificationsUntilCommit() != 0) {
            throw new TestErrorException("modification deferral level 'NONE' not copied to and from XML");
        }
        if (project.getDescriptor(Employee.class).getCMPPolicy().getNonDeferredCreateTime() != 1) {
            throw new TestErrorException("non deferred create time 'AFTER_EJBCREATE' not copied to and from XML");
        }
        descriptor.getCMPPolicy().setDeferModificationsUntilCommit(2);
        descriptor.getCMPPolicy().setNonDeferredCreateTime(2);
        XMLProjectWriter.write((String)"NonDeferredProject.xml", (Project)this.employeeProject);
        project = XMLProjectReader.read((String)"NonDeferredProject.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        if (project.getDescriptor(Employee.class).getCMPPolicy().getDeferModificationsUntilCommit() != 2) {
            throw new TestErrorException("modification deferral level 'ALL_MODIFICATIONS' not copied to and from XML");
        }
        if (project.getDescriptor(Employee.class).getCMPPolicy().getNonDeferredCreateTime() != 2) {
            throw new TestErrorException("non deferred create time 'AFTER_EJBPOSTCREATE' not copied to and from XML");
        }
        descriptor.getCMPPolicy().setDeferModificationsUntilCommit(1);
        descriptor.getCMPPolicy().setNonDeferredCreateTime(0);
        XMLProjectWriter.write((String)"NonDeferredProject.xml", (Project)this.employeeProject);
        project = XMLProjectReader.read((String)"NonDeferredProject.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        if (project.getDescriptor(Employee.class).getCMPPolicy().getDeferModificationsUntilCommit() != 1) {
            throw new TestErrorException("modification deferral level 'UPDATE_MODIFICATIONS' not copied to and from XML");
        }
        if (project.getDescriptor(Employee.class).getCMPPolicy().getNonDeferredCreateTime() != 0) {
            throw new TestErrorException("non deferred create time 'UNDEFINED' not copied to and from XML");
        }
    }

    public void reset() {
        File file = new File("NonDeferredProject.xml");
        file.delete();
    }
}

