/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.LockObject;

public class ChangeSetOptimisticLockingUpdateTest
extends TestCase {
    protected UnitOfWork uow;
    protected Object originalObject;
    protected Class domainClass;

    public ChangeSetOptimisticLockingUpdateTest(Class aClass) {
        this.setName(this.getName() + "(" + aClass + ")");
        this.domainClass = aClass;
        this.setDescription("This test verifies that a changeset gets the correct writelock value");
    }

    protected void setup() {
        this.beginTransaction();
        this.uow = this.getSession().acquireUnitOfWork();
        this.originalObject = this.uow.readObject(this.domainClass);
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        ((LockObject)this.originalObject).value = "Time:" + System.currentTimeMillis();
        this.uow.commit();
    }

    protected void verify() {
        ObjectChangeSet changeSet = (ObjectChangeSet)this.uow.getUnitOfWorkChangeSet().getObjectChangeSetForClone(this.originalObject);
        Object lockValue = this.getSession().getDescriptor(this.domainClass).getOptimisticLockingPolicy().getWriteLockValue(this.originalObject, changeSet.getId(), (AbstractSession)this.getSession());
        if (lockValue instanceof Number ? ((Number)changeSet.getWriteLockValue()).longValue() != ((Number)lockValue).longValue() : !changeSet.getWriteLockValue().equals(lockValue)) {
            throw new TestErrorException("The Write Lock Value was not updated within the Object Change Set");
        }
    }
}

