/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class ReadObjectInMemoryComplexExpressionEmployeeTest
extends PerformanceTest {
    public ReadObjectInMemoryComplexExpressionEmployeeTest() {
        this.setDescription("This tests the performance of in-memory read-object queries.");
    }

    @Override
    public void setup() {
        super.setup();
        this.allObjects = this.getSession().readAllObjects(Employee.class);
        for (Employee employee : this.allObjects) {
            employee.getAddress();
            employee.getPhoneNumbers().size();
        }
    }

    @Override
    public void test() throws Exception {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder employee = new ExpressionBuilder();
        query.setSelectionCriteria(employee.get("firstName").equal((Object)"Brendan").and(employee.get("salary").equal(100000)).and(employee.get("address").get("city").like("%pean%")).and(employee.anyOf("phoneNumbers").get("type").equal((Object)"Home")));
        query.checkCacheOnly();
        Employee result = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
    }
}

