/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class PartialAttributeDistinctOrderByTest
extends AutoVerifyTestCase {
    protected Exception exception = null;
    protected List results = null;

    public void test() {
        try {
            ReadAllQuery query = new ReadAllQuery(Employee.class);
            query.dontMaintainCache();
            query.useDistinct();
            query.addPartialAttribute("firstName");
            query.addPartialAttribute("address");
            query.addOrdering(query.getExpressionBuilder().get("firstName"));
            this.results = (List)this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("Partial Attribute query with joining failed with exception. " + this.exception.toString());
        }
        if (this.results.size() != 12) {
            throw new TestErrorException("Incorrect number of Employees returned.");
        }
        Iterator i = this.results.iterator();
        String previousValue = "AAAAA";
        while (i.hasNext()) {
            Employee e = (Employee)i.next();
            if (e.getFirstName().compareTo(previousValue) < 0) {
                throw new TestErrorException("Order is incorrect between: " + e.getFirstName() + " and: " + previousValue + ".");
            }
            previousValue = e.getFirstName();
        }
    }
}

