/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class SetReferenceClassTest
extends AutoVerifyTestCase {
    protected ReadObjectQuery testQuery;
    protected ClassDescriptor employeeDescriptor;

    public SetReferenceClassTest() {
        this.setDescription("This test verifies that the reference class on the query remains after being added to the DescriptorQueryMechanism.  Bug 3037982");
    }

    public void reset() {
        this.employeeDescriptor.getQueryManager().removeQuery(this.testQuery.getName());
    }

    protected void setup() {
        this.testQuery = new ReadObjectQuery(PhoneNumber.class);
        this.testQuery.setSelectionCriteria(new ExpressionBuilder().get("owner").get("firstName").equal((Object)"Bob"));
        this.testQuery.setName("bug 3037982 test Query");
        this.employeeDescriptor = (ClassDescriptor)this.getSession().getProject().getDescriptors().get(Employee.class);
    }

    public void test() {
        this.employeeDescriptor.getQueryManager().addQuery(this.testQuery.getName(), (DatabaseQuery)this.testQuery);
        PhoneNumber emp = (PhoneNumber)this.getSession().executeQuery(this.testQuery.getName(), Employee.class);
    }

    protected void verify() {
        if (this.testQuery.getReferenceClass() != PhoneNumber.class) {
            throw new TestErrorException("The reference class was overridden by addQuery");
        }
    }
}

