/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class UnitOfWorkConformTest
extends TestCase {
    protected int expected;
    protected UnitOfWork uow;
    protected Vector result;
    protected ReadAllQuery query;

    public UnitOfWorkConformTest(ReadAllQuery query, int size) {
        this.expected = size;
        this.query = query;
        this.setDescription("Test that the query is done on the unit of work changes.");
    }

    public void reset() {
        this.uow.release();
    }

    protected void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.readAllObjects(Employee.class);
        Employee newEmployee = new Employee();
        newEmployee.setFirstName("Bob");
        this.uow.registerObject((Object)newEmployee);
        newEmployee = new Employee();
        newEmployee.setFirstName("newBobby");
        this.uow.registerNewObject((Object)newEmployee);
        this.uow.deleteObject(this.uow.readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Sarah")));
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee example = (Employee)manager.getObject(Employee.class, "0001");
        Employee clone = (Employee)this.uow.readObject((Object)example);
        clone.setLastName("Bobo");
    }

    public void test() {
        this.result = (Vector)this.uow.executeQuery((DatabaseQuery)this.query);
    }

    protected void verify() {
        if (this.result.size() != this.expected) {
            throw new TestErrorException("Expecting: " + this.expected + " retrieved: " + this.result.size());
        }
    }
}

