/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class BatchReadingUnitOfWorkInTransactionTest
extends TestCase {
    BatchFetchType batchType;
    public UnitOfWork myUOW;
    private ReadAllQuery myQuery;

    public BatchReadingUnitOfWorkInTransactionTest(BatchFetchType batchType) {
        this.setDescription("This test verifies that batch reading works correctly in a unit of work while a transaction has already started");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public ReadAllQuery getMyQuery() {
        return this.myQuery;
    }

    public UnitOfWork getMyUOW() {
        return this.myUOW;
    }

    protected void setMyQuery(ReadAllQuery newValue) {
        this.myQuery = newValue;
    }

    public void setMyUOW(UnitOfWork newValue) {
        this.myUOW = newValue;
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.setMyUOW(this.getSession().acquireUnitOfWork());
        this.setMyQuery(new ReadAllQuery());
        this.getMyQuery().setBatchFetchType(this.batchType);
        this.getMyQuery().setReferenceClass(Employee.class);
        this.getMyQuery().addBatchReadAttribute("address");
    }

    public void test() {
        this.getMyUOW().executeNonSelectingCall((Call)new SQLCall("UPDATE EMPLOYEE SET L_NAME = 'Jefferson' WHERE (L_NAME = 'Jefferson')"));
        try {
            Vector employees = (Vector)this.getMyUOW().executeQuery((DatabaseQuery)this.getMyQuery());
            ((Employee)employees.firstElement()).getAddress().getCity();
            this.getMyUOW().commit();
        }
        catch (Exception exception) {
            this.getMyUOW().release();
        }
    }
}

