/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class GetIdentityMapFromUOWForREADONLYClassTest
extends AutoVerifyTestCase {
    public UnitOfWork uow;
    Employee employee;

    public GetIdentityMapFromUOWForREADONLYClassTest() {
        this.setDescription("This test verifies that READ-ONLY class feauture should work if UnitOfWork.getFromIdentityMap() is called  ");
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
        this.employee = (Employee)this.getSession().readObject(Employee.class);
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void test() {
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.addReadOnlyClass(this.employee.getClass());
        this.uow.getIdentityMapAccessor().getFromIdentityMap(this.getSession().getId((Object)this.employee), this.employee.getClass());
        this.uow.commit();
    }

    protected void verify() {
        if (!((UnitOfWorkImpl)this.uow).getCloneMapping().isEmpty()) {
            throw new TestErrorException("READ-ONLY class feature failed when getFromIdentityMap() is called");
        }
    }
}

