/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import junit.framework.Test;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedObjectReferenceChangesTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedTest;
import org.eclipse.persistence.testing.tests.unitofwork.MultipleUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitResumeOnFailureNoFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeOnFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRevertTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.ALCTEmployeeSystem;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.AggregateAttributeChangeTrackingTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.ChangeFlagTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.EmployeeChangeFlagBasicTestModel;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.NestedUOWWithAttributeChangeTrackingTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.TransparentMapTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.WrongPropertyNameTest;
import org.eclipse.persistence.testing.tests.unitofwork.referencesettings.ChangeTrackedWeakReferenceTest;
import org.eclipse.persistence.testing.tests.unitofwork.referencesettings.DeferredChangeWeakReferenceTest;
import org.eclipse.persistence.testing.tests.unitofwork.referencesettings.ForceWeakReferenceTest;
import org.eclipse.persistence.testing.tests.unitofwork.referencesettings.HardReferenceTest;
import org.eclipse.persistence.testing.tests.unitofwork.referencesettings.WeakReferenceTest;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeNothingTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeObjectTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeValueTest;
import org.eclipse.persistence.testing.tests.writing.UpdateToNullTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeAttributeChangeTrackingTestModel
extends EmployeeChangeFlagBasicTestModel {
    public EmployeeAttributeChangeTrackingTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo with AttributeChangeTrackingPolicy flag.");
    }

    @Override
    public void addRequiredSystems() {
        super.addRequiredSystems();
        this.addRequiredSystem(new ALCTEmployeeSystem());
    }

    @Override
    public void setup() {
        this.employeeChangePolicy = this.getSession().getDescriptor(Employee.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Employee.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.addressChangePolicy = this.getSession().getDescriptor(Address.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Address.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.projectChangePolicy = this.getSession().getDescriptor(Project.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Project.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.smallProjectChangePolicy = this.getSession().getDescriptor(SmallProject.class).getObjectChangePolicy();
        this.getSession().getDescriptor(SmallProject.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.largeProjectChangePolicy = this.getSession().getDescriptor(LargeProject.class).getObjectChangePolicy();
        this.getSession().getDescriptor(LargeProject.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.employmentPeriodChangePolicy = this.getSession().getDescriptor(EmploymentPeriod.class).getObjectChangePolicy();
        this.getSession().getDescriptor(EmploymentPeriod.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("period").getReferenceDescriptor().setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.phoneNumberChangePolicy = this.getSession().getDescriptor(PhoneNumber.class).getObjectChangePolicy();
        this.getSession().getDescriptor(PhoneNumber.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.restaurantChangePolicy = this.getSession().getDescriptor(Restaurant.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Restaurant.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
    }

    @Override
    public TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Unit Of Work Update Test Suite");
        suite.setDescription("This suite tests change flags for updates using UnitOfWork");
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employee = (Employee)manager.getObject(Employee.class, "0001");
        ComplexUpdateTest test = new UpdateToNullTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeValueTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeNothingTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeObjectTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        suite.addTest((Test)new MultipleUnitOfWorkTest(employee));
        suite.addTest((Test)new UnitOfWorkResumeTest(employee));
        suite.addTest((Test)new UnitOfWorkResumeOnFailureTest(employee));
        suite.addTest((Test)new UnitOfWorkCommitResumeOnFailureNoFailureTest(employee));
        suite.addTest((Test)new UnitOfWorkRevertTest(employee));
        suite.addTest((Test)new ChangeFlagTest());
        suite.addTest((Test)new NestedUOWWithAttributeChangeTrackingTest(employee));
        suite.addTest((Test)new WrongPropertyNameTest());
        suite.addTest((Test)new DeepMergeCloneSerializedTest());
        suite.addTest((Test)new DeepMergeCloneSerializedObjectReferenceChangesTest());
        suite.addTest((Test)new TransparentMapTest());
        suite.addTest((Test)new AggregateAttributeChangeTrackingTest());
        suite.addTest((Test)new ChangeTrackedWeakReferenceTest());
        suite.addTest((Test)new DeferredChangeWeakReferenceTest());
        suite.addTest((Test)new ForceWeakReferenceTest());
        suite.addTest((Test)new HardReferenceTest());
        suite.addTest((Test)new WeakReferenceTest());
        return suite;
    }
}

