/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ServerSessionReadPoolTypeTest
extends AutoVerifyTestCase {
    protected ServerSession serverSession;

    public ServerSessionReadPoolTypeTest() {
        this.setDescription("This test validates the type of ServerSession's readConnectionPool");
    }

    public void setup() {
        DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.serverSession = new ServerSession((Login)login, 1, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
    }

    public void verify() {
        Class<?> readPoolClass = this.serverSession.getReadConnectionPool().getClass();
        String readPoolClassName = Helper.getShortClassName(readPoolClass);
        if (this.serverSession.getLogin().shouldUseExternalConnectionPooling()) {
            if (!readPoolClass.equals(ExternalConnectionPool.class)) {
                throw new TestErrorException("In case external connection pooling is used, readConnectionPool by default should be an instance of ExternalConnectionPool class, not " + readPoolClassName);
            }
        } else if (!readPoolClass.equals(ConnectionPool.class)) {
            throw new TestErrorException("In case external connection pooling is NOT used, readConnectionPool by default should be an instance of ConnectionPool class, not " + readPoolClassName);
        }
    }

    public void reset() {
        if (this.serverSession != null) {
            this.serverSession.logout();
            this.serverSession = null;
        }
    }
}

