/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMFlushBatchWritingTest
extends EntityContainerTestBase {
    protected boolean reset = false;
    private boolean usesBatchWriting;
    private boolean usesJDBCBatchWriting;

    public EMFlushBatchWritingTest() {
        this.setDescription("Test flush multiple times in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        JpaEntityManager em = JpaHelper.getEntityManager((EntityManager)this.getEntityManager());
        DatabasePlatform platform = em.getServerSession().getPlatform();
        this.usesBatchWriting = platform.usesBatchWriting();
        this.usesJDBCBatchWriting = platform.usesJDBCBatchWriting();
        platform.setUsesBatchWriting(true);
        platform.setUsesJDBCBatchWriting(true);
        em.close();
        this.reset = true;
    }

    @Override
    public void reset() {
        if (this.reset) {
            JpaEntityManager em = JpaHelper.getEntityManager((EntityManager)this.getEntityManager());
            DatabasePlatform platform = em.getServerSession().getPlatform();
            platform.setUsesBatchWriting(this.usesBatchWriting);
            platform.setUsesJDBCBatchWriting(this.usesJDBCBatchWriting);
            em.close();
            this.reset = false;
        }
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Exception expectedException = null;
        try {
            this.beginTransaction();
            EntityManager em = this.getEntityManager();
            Query query = em.createNativeQuery("unexecutable native sql query");
            try {
                query.executeUpdate();
            }
            catch (Exception e) {
                throw new TestWarningException("ExcuteUpdate threw an exception while using batch writing instead of waiting for the commit/flush call");
            }
            try {
                em.flush();
            }
            catch (Exception e) {
                expectedException = e;
            }
        }
        finally {
            this.rollbackTransaction();
        }
        EMFlushBatchWritingTest.assertNotNull((String)"Native query did not get executed when EntityManager was flushed", (Object)expectedException);
    }
}

