/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;

public class ReportQueryAdvancedJUnitTest
extends JUnitTestCase {
    protected static Class[] classes = new Class[]{Employee.class, Address.class, PhoneNumber.class, Project.class};
    protected static Vector[] objectVectors = new Vector[]{null, null, null, null};
    protected static EmployeePopulator populator = new EmployeePopulator();

    public ReportQueryAdvancedJUnitTest() {
    }

    public ReportQueryAdvancedJUnitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
        if (!ReportQueryAdvancedJUnitTest.compare()) {
            this.clear();
            this.populate();
        }
    }

    protected static DatabaseSession getDbSession() {
        return ReportQueryAdvancedJUnitTest.getServerSession();
    }

    protected static UnitOfWork acquireUnitOfWork() {
        return ReportQueryAdvancedJUnitTest.getDbSession().acquireUnitOfWork();
    }

    protected void clear() {
        UnitOfWork uow = ReportQueryAdvancedJUnitTest.acquireUnitOfWork();
        if (!JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            UpdateAllQuery updateEmployees = new UpdateAllQuery(Employee.class);
            updateEmployees.addUpdate("manager", null);
            updateEmployees.addUpdate("address", null);
            uow.executeQuery((DatabaseQuery)updateEmployees);
        } else {
            for (Employee emp : uow.readAllObjects(Employee.class)) {
                emp.setManager(null);
                emp.setAddress((String)null);
                uow.deleteObject((Object)emp);
            }
        }
        UpdateAllQuery updateProjects = new UpdateAllQuery(Project.class);
        updateProjects.addUpdate("teamLeader", null);
        uow.executeQuery((DatabaseQuery)updateProjects);
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(PhoneNumber.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Address.class));
        if (!JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Employee.class));
        }
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Project.class));
        uow.commit();
        this.clearCache();
    }

    protected void populate() {
        populator.buildExamples();
        populator.persistExample((Session)ReportQueryAdvancedJUnitTest.getDbSession());
        this.clearCache();
        for (int i = 0; i < classes.length; ++i) {
            ReportQueryAdvancedJUnitTest.objectVectors[i] = ReportQueryAdvancedJUnitTest.getDbSession().readAllObjects(classes[i]);
        }
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReportQueryAdvancedJUnitTest");
        suite.addTest((Test)new ReportQueryAdvancedJUnitTest("testSetup"));
        suite.addTest((Test)new ReportQueryAdvancedJUnitTest("testPhoneCountGroupByOwner"));
        suite.addTest((Test)new ReportQueryAdvancedJUnitTest("testPhoneCountGroupByOwnersAddress"));
        suite.addTest((Test)new ReportQueryAdvancedJUnitTest("testProjectCountGroupByTeamMembers"));
        suite.addTest((Test)new ReportQueryAdvancedJUnitTest("testProjectCountGroupByTeamMemberAddress"));
        suite.addTest((Test)new ReportQueryAdvancedJUnitTest("testProjectCountGroupByTeamMemberPhone"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testPhoneCountGroupByOwner() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(PhoneNumber.class, builder);
        Expression groupingExp = builder.get("owner");
        reportQuery.addItem("owner", groupingExp);
        reportQuery.addItem("phonesCount", builder.count());
        reportQuery.addGrouping(groupingExp);
        Vector results = (Vector)ReportQueryAdvancedJUnitTest.getDbSession().executeQuery((DatabaseQuery)reportQuery);
        for (int i = 0; i < results.size(); ++i) {
            ReportQueryResult reportResult = (ReportQueryResult)results.elementAt(i);
            Employee employee = (Employee)reportResult.get("owner");
            int count = ((Number)reportResult.get("phonesCount")).intValue();
            if (employee.getPhoneNumbers().size() == count) continue;
            ReportQueryAdvancedJUnitTest.fail((String)(employee.toString() + " has " + employee.getPhoneNumbers().size() + " phones, ReportQuery returned " + count));
        }
    }

    public void testPhoneCountGroupByOwnersAddress() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(PhoneNumber.class, builder);
        Expression groupingExp = builder.get("owner").get("address");
        reportQuery.addItem("ownerAddress", groupingExp);
        reportQuery.addItem("phonesCount", builder.count());
        reportQuery.addGrouping(groupingExp);
        Vector results = (Vector)ReportQueryAdvancedJUnitTest.getDbSession().executeQuery((DatabaseQuery)reportQuery);
        for (int i = 0; i < results.size(); ++i) {
            ReportQueryResult reportResult = (ReportQueryResult)results.elementAt(i);
            Address address = (Address)reportResult.get("ownerAddress");
            Employee employee = (Employee)ReportQueryAdvancedJUnitTest.getDbSession().readObject(Employee.class, new ExpressionBuilder().get("address").equal((Object)address));
            int count = ((Number)reportResult.get("phonesCount")).intValue();
            if (employee.getPhoneNumbers().size() == count) continue;
            ReportQueryAdvancedJUnitTest.fail((String)(employee.toString() + " has " + employee.getPhoneNumbers().size() + " phones, ReportQuery returned " + count));
        }
    }

    public void testProjectCountGroupByTeamMembers() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(Project.class, builder);
        Expression groupingExp = builder.anyOf("teamMembers");
        reportQuery.addItem("projectTeamMember", groupingExp);
        reportQuery.addItem("projectsCount", builder.count());
        reportQuery.addGrouping(groupingExp);
        Vector results = (Vector)ReportQueryAdvancedJUnitTest.getDbSession().executeQuery((DatabaseQuery)reportQuery);
        for (int i = 0; i < results.size(); ++i) {
            ReportQueryResult reportResult = (ReportQueryResult)results.elementAt(i);
            Employee employee = (Employee)reportResult.get("projectTeamMember");
            int count = ((Number)reportResult.get("projectsCount")).intValue();
            if (employee.getProjects().size() == count) continue;
            ReportQueryAdvancedJUnitTest.fail((String)(employee.toString() + " is a team member on  " + employee.getProjects().size() + " projects, ReportQuery returned " + count));
        }
    }

    public void testProjectCountGroupByTeamMemberAddress() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(Project.class, builder);
        Expression groupingExp = builder.anyOf("teamMembers").get("address");
        reportQuery.addItem("projectTeamMemberAddress", groupingExp);
        reportQuery.addItem("projectsCount", builder.count());
        reportQuery.addGrouping(groupingExp);
        Vector results = (Vector)ReportQueryAdvancedJUnitTest.getDbSession().executeQuery((DatabaseQuery)reportQuery);
        for (int i = 0; i < results.size(); ++i) {
            ReportQueryResult reportResult = (ReportQueryResult)results.elementAt(i);
            Address address = (Address)reportResult.get("projectTeamMemberAddress");
            Employee employee = (Employee)ReportQueryAdvancedJUnitTest.getDbSession().readObject(Employee.class, new ExpressionBuilder().get("address").equal((Object)address));
            int count = ((Number)reportResult.get("projectsCount")).intValue();
            if (employee.getProjects().size() == count) continue;
            ReportQueryAdvancedJUnitTest.fail((String)(employee.toString() + " is a team member on  " + employee.getProjects().size() + " projects, ReportQuery returned " + count));
        }
    }

    public void testProjectCountGroupByTeamMemberPhone() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(Project.class, builder);
        Expression groupingExp = builder.anyOf("teamMembers").anyOf("phoneNumbers");
        reportQuery.addItem("projectTeamMemberPhone", groupingExp);
        reportQuery.addItem("projectsCount", builder.count());
        reportQuery.addGrouping(groupingExp);
        Vector results = (Vector)ReportQueryAdvancedJUnitTest.getDbSession().executeQuery((DatabaseQuery)reportQuery);
        for (int i = 0; i < results.size(); ++i) {
            ReportQueryResult reportResult = (ReportQueryResult)results.elementAt(i);
            PhoneNumber phone = (PhoneNumber)reportResult.get("projectTeamMemberPhone");
            Employee employee = phone.getOwner();
            int count = ((Number)reportResult.get("projectsCount")).intValue();
            if (employee.getProjects().size() == count) continue;
            ReportQueryAdvancedJUnitTest.fail((String)(employee.toString() + " is a team member on  " + employee.getProjects().size() + " projects, ReportQuery returned " + count));
        }
    }

    protected static boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (ReportQueryAdvancedJUnitTest.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = ReportQueryAdvancedJUnitTest.getDbSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = ReportQueryAdvancedJUnitTest.getDbSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)ReportQueryAdvancedJUnitTest.getDbSession())) continue;
            return false;
        }
        return true;
    }
}

