/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.beanvalidation;

import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.Address;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.BeanValidationPopulator;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.BeanValidationTableCreator;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.Employee;

public class BeanValidationJunitTest
extends JUnitTestCase {
    public BeanValidationJunitTest() {
    }

    public BeanValidationJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("BeanValidationJunitTest");
        suite.addTest((Test)new BeanValidationJunitTest("testSetup"));
        suite.addTest((Test)new BeanValidationJunitTest("testPersistWithInvalidData"));
        suite.addTest((Test)new BeanValidationJunitTest("testEmbeddedWithInvalidData"));
        suite.addTest((Test)new BeanValidationJunitTest("testUpdateWithInvalidData"));
        suite.addTest((Test)new BeanValidationJunitTest("testRemoveWithInvalidData"));
        suite.addTest((Test)new BeanValidationJunitTest("testTraversableResolverPreventsLoadingOfLazyRelationships"));
        suite.addTest((Test)new BeanValidationJunitTest("testTraversableResolverPreventsTraversingRelationshipdMultipleTimes"));
        return suite;
    }

    public void testSetup() {
        new BeanValidationTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        EntityManager em = this.createBVEntityManager();
        BeanValidationPopulator.createEmployeeProject((EntityManager)em);
        em.close();
    }

    public void testPersistWithInvalidData() {
        EntityManager em = this.createBVEntityManager();
        EntityTransaction tx = em.getTransaction();
        boolean gotConstraintViolations = false;
        String invalidName = BeanValidationPopulator.getFilledStringOfLength((int)6);
        try {
            tx.begin();
            Employee e1 = new Employee(100, invalidName, 1000L);
            em.persist((Object)e1);
        }
        catch (ConstraintViolationException e) {
            BeanValidationJunitTest.assertTrue((String)"Transaction not marked for roll back when ConstraintViolation is thrown", (boolean)tx.getRollbackOnly());
            tx.rollback();
            Set constraintViolations = e.getConstraintViolations();
            ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
            Object invalidaValue = constraintViolation.getInvalidValue();
            BeanValidationJunitTest.assertTrue((String)("Invalid value should be " + invalidName), (boolean)invalidName.equals(invalidaValue));
            gotConstraintViolations = true;
        }
        BeanValidationJunitTest.assertTrue((String)"Did not get Constraint Violation while persisting invalid data ", (boolean)gotConstraintViolations);
    }

    public void testEmbeddedWithInvalidData() {
        EntityManager em = this.createBVEntityManager();
        EntityTransaction tx = em.getTransaction();
        boolean gotConstraintViolations = false;
        try {
            tx.begin();
            Employee e1 = new Employee(100, "name", 1000L);
            Address address = new Address("street", "city", "state");
            e1.setAddress(address);
            em.persist((Object)e1);
        }
        catch (ConstraintViolationException e) {
            BeanValidationJunitTest.assertTrue((String)"Transaction not marked for roll back when ConstraintViolation is thrown", (boolean)tx.getRollbackOnly());
            tx.rollback();
            gotConstraintViolations = true;
        }
        BeanValidationJunitTest.assertTrue((String)"Did not get Constraint Violation while persisting invalid data ", (boolean)gotConstraintViolations);
    }

    public void testUpdateWithInvalidData() {
        EntityManager em = this.createBVEntityManager();
        EntityTransaction tx = em.getTransaction();
        boolean gotConstraintViolations = false;
        String invalidName = BeanValidationPopulator.getFilledStringOfLength((int)6);
        try {
            tx.begin();
            Employee e = (Employee)em.find(Employee.class, (Object)1);
            e.setName(invalidName);
            tx.commit();
        }
        catch (PersistenceException e) {
            BeanValidationJunitTest.assertFalse((String)"Transaction not marked for roll back when ConstraintViolation is thrown", (boolean)tx.isActive());
            Throwable cause = e.getCause();
            BeanValidationJunitTest.assertTrue((String)"The nested cause should be instance of ConstraintViolationException", (boolean)(cause instanceof ConstraintViolationException));
            ConstraintViolationException cve = (ConstraintViolationException)cause;
            Set constraintViolations = cve.getConstraintViolations();
            ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
            BeanValidationJunitTest.assertTrue((String)("Invalid value should be " + invalidName), (boolean)invalidName.equals(constraintViolation.getInvalidValue()));
            gotConstraintViolations = true;
        }
        BeanValidationJunitTest.assertTrue((String)"Did not get Constraint Violation while updating with invalid data ", (boolean)gotConstraintViolations);
    }

    public void testRemoveWithInvalidData() {
        EntityManager em = this.createBVEntityManager();
        EntityTransaction tx = em.getTransaction();
        boolean removeSuccessfull = false;
        int EMPLOYEE_PK_TO_REMOVE = 2;
        tx.begin();
        Employee e1 = new Employee(2, BeanValidationPopulator.getFilledStringOfLength((int)4), 1000L);
        em.persist((Object)e1);
        tx.commit();
        tx.begin();
        Employee e = (Employee)em.find(Employee.class, (Object)2);
        e.setName(BeanValidationPopulator.getFilledStringOfLength((int)6));
        em.remove((Object)e);
        tx.commit();
        removeSuccessfull = true;
        BeanValidationJunitTest.assertTrue((String)"Automatic Validation should not be executed for remove", (boolean)removeSuccessfull);
    }

    public void testTraversableResolverPreventsLoadingOfLazyRelationships() {
        EntityManagerFactory emf = this.createBVEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        emf.getCache().evictAll();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        Employee employee = (Employee)em.find(Employee.class, (Object)1);
        employee.setName(BeanValidationPopulator.getFilledStringOfLength((int)3));
        tx.commit();
        Project project = JpaHelper.getServerSession((EntityManagerFactory)emf).getProject();
        BeanValidationJunitTest.assertTrue((String)"Lazy field should not be instantiated because of validation", (!this.isInstantiated(employee, "projects", project) ? 1 : 0) != 0);
        BeanValidationJunitTest.assertTrue((String)"Lazy field should not be instantiated because of validation", (!this.isInstantiated(employee, "managedProject", project) ? 1 : 0) != 0);
    }

    public void testTraversableResolverPreventsTraversingRelationshipdMultipleTimes() {
    }

    private boolean isInstantiated(Object entityObject, String attributeName, Project project) {
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)project.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName(attributeName);
        Object attributeValue = mapping.getAttributeAccessor().getAttributeValueFromObject(entityObject);
        return mapping.getIndirectionPolicy().objectIsInstantiatedOrChanged(attributeValue);
    }

    public EntityManager createBVEntityManager() {
        return JUnitTestCase.createEntityManager((String)"beanvalidation");
    }

    public EntityManagerFactory createBVEntityManagerFactory() {
        return JUnitTestCase.getEntityManagerFactory((String)"beanvalidation");
    }
}

