/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.complexaggregate;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.CoachVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyCoach;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyPlayer;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyTeam;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.PersonalVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Role;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.TeamVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Vitals;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class ComplexAggregateJoin
extends EntityContainerTestBase {
    protected Session m_session;
    HockeyTeam team1;
    HockeyPlayer player1;
    HockeyCoach coach1;
    List<HockeyCoach> hockeyCoachResults;
    List<HockeyCoach> controledCoachList;
    List<HockeyPlayer> hockeyPlayerResults;
    List<HockeyPlayer> controledPlayerList;

    public ComplexAggregateJoin() {
        this.setDescription("Tests nested aggregates with relational mappings.");
    }

    public void populate(EntityManager em) {
        this.team1 = new HockeyTeam();
        this.team1.setName("Axemen");
        this.team1.setAwayColor("Red");
        this.team1.setHomeColor("White");
        this.team1.setLevel("Division 5");
        this.player1 = new HockeyPlayer();
        this.player1.setFirstName("Guy");
        this.player1.setLastName("Pelletier");
        PersonalVitals personalVitals1 = new PersonalVitals();
        personalVitals1.setAge(29);
        personalVitals1.setHeight(1.8);
        personalVitals1.setWeight(180.0);
        TeamVitals teamVitals1 = new TeamVitals();
        teamVitals1.setJerseyNumber(20);
        teamVitals1.setPosition("Goalie");
        teamVitals1.getRoles().add(new Role("Stop pucks!"));
        Vitals vitals1 = new Vitals();
        vitals1.setPersonalVitals(personalVitals1);
        vitals1.setTeamVitals(teamVitals1);
        this.player1.setVitals(vitals1);
        this.coach1 = new HockeyCoach();
        this.coach1.setFirstName("Don");
        this.coach1.setLastName("Hyslop");
        PersonalVitals coachPersonalVitals1 = new PersonalVitals();
        coachPersonalVitals1.setAge(55);
        coachPersonalVitals1.setHeight(1.85);
        coachPersonalVitals1.setWeight(200.0);
        CoachVitals coachVitals1 = new CoachVitals();
        coachVitals1.setPersonalVitals(coachPersonalVitals1);
        this.coach1.setVitals(coachVitals1);
        this.getEntityManager().persist((Object)this.team1);
        this.getEntityManager().persist((Object)this.player1);
        this.getEntityManager().persist((Object)this.coach1);
        teamVitals1.setHockeyTeam(this.team1);
        this.team1.getPlayers().add(this.player1);
        this.team1.getCoaches().add(this.coach1);
        coachVitals1.setHockeyTeam(this.team1);
        this.getEntityManager().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        try {
            this.beginTransaction();
            this.populate(this.getEntityManager());
            this.getEntityManager().clear();
            this.m_session = ((EntityManagerImpl)this.getEntityManager()).getServerSession();
            this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            Query query1 = this.getEntityManager().createQuery("Select a from HockeyCoach a where a.id = " + this.coach1.getId());
            query1.setHint("eclipselink.left-join-fetch", (Object)"a.vitals.hockeyTeam");
            this.hockeyCoachResults = query1.getResultList();
            this.getEntityManager().clear();
            this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            Query query2 = this.getEntityManager().createQuery("Select z from HockeyPlayer z where z.playerId = " + this.player1.getPlayerId());
            query2.setHint("eclipselink.left-join-fetch", (Object)"z.vitals.teamVitals.hockeyTeam.coaches");
            this.hockeyPlayerResults = query2.getResultList();
            this.getEntityManager().clear();
            this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            HockeyCoach expectedCoach = (HockeyCoach)this.getEntityManager().find(HockeyCoach.class, (Object)this.coach1.getId());
            expectedCoach.getVitals().getHockeyTeam();
            this.controledCoachList = new ArrayList<HockeyCoach>(1);
            this.controledCoachList.add(expectedCoach);
            this.getEntityManager().clear();
            this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            HockeyPlayer expectedPlayer = (HockeyPlayer)this.getEntityManager().find(HockeyPlayer.class, (Object)this.player1.getPlayerId());
            expectedPlayer.getVitals().getTeamVitals().getHockeyTeam().getCoaches().size();
            this.controledPlayerList = new ArrayList<HockeyPlayer>(1);
            this.controledPlayerList.add(expectedPlayer);
            this.getEntityManager().clear();
            this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        finally {
            try {
                this.rollbackTransaction();
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public void verify() {
        String errorMsg = JoinedAttributeTestHelper.compareCollections(this.controledCoachList, this.hockeyCoachResults, (ClassDescriptor)this.m_session.getClassDescriptor(HockeyCoach.class), (AbstractSession)((AbstractSession)this.m_session));
        if (errorMsg.length() > 0) {
            throw new TestErrorException(errorMsg);
        }
        errorMsg = JoinedAttributeTestHelper.compareCollections(this.controledPlayerList, this.hockeyPlayerResults, (ClassDescriptor)this.m_session.getClassDescriptor(HockeyPlayer.class), (AbstractSession)((AbstractSession)this.m_session));
        if (errorMsg.length() > 0) {
            throw new TestErrorException(errorMsg);
        }
    }
}

