/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.complexaggregate;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Body;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Heart;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.Torso;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class NestedAggregatePrimaryKeyTest
extends EntityContainerTestBase {
    protected Session m_session;
    protected boolean m_reset = false;
    protected Body m_refreshedBody;
    protected Exception m_testException;

    public NestedAggregatePrimaryKeyTest() {
        this.setDescription("Tests nested aggregates used as the primary key class.");
    }

    @Override
    public void setup() {
        super.setup();
        this.m_reset = true;
        this.m_refreshedBody = null;
        this.m_testException = null;
        this.m_session = ((EntityManagerImpl)this.getEntityManager()).getActiveSession();
        this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() throws Exception {
        Torso torso;
        try {
            Body body = new Body();
            torso = new Torso();
            Heart heart = new Heart();
            heart.setSize(8);
            torso.setHeart(heart);
            body.setTorso(torso);
            this.beginTransaction();
            this.getEntityManager().persist((Object)body);
            this.commitTransaction();
        }
        catch (Exception e) {
            throw new TestErrorException("Exception caught when persisting the new body: " + e.getMessage());
        }
        finally {
            this.getEntityManager().close();
        }
        try {
            this.getEntityManager().clear();
            this.m_session = ((EntityManagerImpl)this.getEntityManager()).getServerSession();
            this.m_session.getIdentityMapAccessor().initializeAllIdentityMaps();
            this.m_refreshedBody = (Body)this.getEntityManager().find(Body.class, (Object)torso);
        }
        catch (Exception e) {
            this.m_testException = e;
        }
    }

    @Override
    public void reset() {
        if (this.m_reset) {
            this.m_reset = false;
        }
    }

    public void verify() {
        if (this.m_testException != null) {
            throw new TestErrorException("Exception caught reading back the persisted body: " + this.m_testException);
        }
        if (this.m_refreshedBody == null) {
            throw new TestErrorException("Unable to read back the persisted body");
        }
        ClassDescriptor descriptor = ((EntityManagerImpl)this.getEntityManager()).getServerSession().getClassDescriptor(Body.class);
        Object pks = descriptor.getObjectBuilder().extractPrimaryKeyFromObject((Object)this.m_refreshedBody, (AbstractSession)this.m_session);
        Torso createdTorso = (Torso)descriptor.getCMPPolicy().createPrimaryKeyInstanceFromId(pks, (AbstractSession)this.m_session);
        NestedAggregatePrimaryKeyTest.assertTrue((String)"PK's do not match.", (boolean)this.m_refreshedBody.getTorso().equals((Object)createdTorso));
    }
}

