/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.mappings;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_AggregateObject {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;

    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
        boolean isMySQL = JpaHelper.getServerSession((EntityManagerFactory)emf).getDatasourcePlatform().getClass().getName().contains("MySQLPlatform");
        Assume.assumeTrue((boolean)isMySQL);
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class simpleTypeB = dcl.createDynamicClass("model.SimpleB");
        JPADynamicTypeBuilder bFactory = new JPADynamicTypeBuilder(simpleTypeB, null, new String[0]);
        bFactory.addDirectMapping("value2", Boolean.TYPE, "VAL_2");
        bFactory.addDirectMapping("value3", String.class, "VAL_3");
        Class simpleTypeC = dcl.createDynamicClass("model.SimpleC");
        JPADynamicTypeBuilder cFactory = new JPADynamicTypeBuilder(simpleTypeC, null, new String[0]);
        cFactory.addDirectMapping("value4", Double.TYPE, "VAL_4");
        cFactory.addDirectMapping("value5", String.class, "VAL_5");
        Class simpleTypeA = dcl.createDynamicClass("model.SimpleA");
        JPADynamicTypeBuilder aFactory = new JPADynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aFactory.setPrimaryKeyFields(new String[]{"SID"});
        aFactory.addDirectMapping("id", Integer.TYPE, "SID");
        aFactory.addDirectMapping("value1", String.class, "VAL_1");
        aFactory.addAggregateObjectMapping("b", bFactory.getType(), true);
        aFactory.addAggregateObjectMapping("c", cFactory.getType(), false);
        helper.addTypes(true, true, new DynamicType[]{aFactory.getType(), bFactory.getType(), cFactory.getType()});
    }

    @AfterClass
    public static void tearDown() {
        if (emf != null && emf.isOpen()) {
            EntityManager em = emf.createEntityManager();
            em.getTransaction().begin();
            em.createNativeQuery("DROP TABLE SIMPLE_TYPE_A").executeUpdate();
            em.getTransaction().commit();
            em.close();
            emf.close();
        }
    }

    @After
    public void clearDynamicTables() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE FROM SimpleA").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = helper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicTypeImpl simpleTypeA = (DynamicTypeImpl)helper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = helper.getSession().getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicTypeImpl simpleTypeB = (DynamicTypeImpl)helper.getType("SimpleB");
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)simpleTypeB);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping b_value2 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value2");
        Assert.assertEquals(Boolean.TYPE, (Object)b_value2.getAttributeClassification());
        DirectToFieldMapping b_value3 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value3");
        Assert.assertEquals(String.class, (Object)b_value3.getAttributeClassification());
        Assert.assertTrue((boolean)descriptorB.isAggregateDescriptor());
        AggregateObjectMapping a_b = (AggregateObjectMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertSame((Object)descriptorB.getJavaClass(), (Object)a_b.getReferenceDescriptor().getJavaClass());
        Assert.assertTrue((boolean)a_b.isNullAllowed());
        ClassDescriptor descriptorC = helper.getSession().getClassDescriptorForAlias("SimpleC");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicTypeImpl simpleTypeC = (DynamicTypeImpl)helper.getType("SimpleC");
        Assert.assertNotNull((String)"'SimpleC' EntityType not found", (Object)simpleTypeC);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping c_value4 = (DirectToFieldMapping)descriptorC.getMappingForAttributeName("value4");
        Assert.assertEquals(Double.TYPE, (Object)c_value4.getAttributeClassification());
        DirectToFieldMapping c_value5 = (DirectToFieldMapping)descriptorC.getMappingForAttributeName("value5");
        Assert.assertEquals(String.class, (Object)c_value5.getAttributeClassification());
        Assert.assertTrue((boolean)descriptorB.isAggregateDescriptor());
        AggregateObjectMapping a_c = (AggregateObjectMapping)descriptorA.getMappingForAttributeName("c");
        Assert.assertSame((Object)descriptorC.getJavaClass(), (Object)a_c.getReferenceDescriptor().getJavaClass());
        Assert.assertFalse((boolean)a_c.isNullAllowed());
    }

    @Test
    public void verifyProperties() {
        DynamicTypeImpl simpleTypeA = (DynamicTypeImpl)helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        Assert.assertEquals((long)4L, (long)simpleTypeA.getNumberOfProperties());
        Assert.assertEquals((Object)"id", simpleTypeA.getPropertiesNames().get(0));
        Assert.assertEquals((Object)"value1", simpleTypeA.getPropertiesNames().get(1));
        Assert.assertEquals((Object)"b", simpleTypeA.getPropertiesNames().get(2));
        Assert.assertEquals((Object)"c", simpleTypeA.getPropertiesNames().get(3));
    }

    @Test
    public void createSimpleA() {
        DynamicTypeImpl simpleTypeA = (DynamicTypeImpl)helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity a = simpleTypeA.newDynamicEntity();
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)a.get("id"), (Object)0);
        Assert.assertFalse((boolean)a.isSet("id"));
        Assert.assertFalse((boolean)a.isSet("value1"));
        Assert.assertFalse((boolean)a.isSet("b"));
        DynamicType typeC = helper.getType("SimpleC");
        Assert.assertEquals(a.get("c").getClass(), typeC.newDynamicEntity().getClass());
        DynamicEntity c = (DynamicEntity)a.get("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)c.get("value4"), (Object)0.0);
        Assert.assertFalse((boolean)c.isSet("value5"));
    }

    @Test
    public void persistSimpleA() {
        DynamicTypeImpl simpleTypeA = (DynamicTypeImpl)helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        em.close();
    }

    @Test
    public void verifyChangTracking() {
        this.persistSimpleA();
        DynamicTypeImpl simpleTypeA = (DynamicTypeImpl)helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        DynamicEntityImpl a = (DynamicEntityImpl)em.find(simpleTypeA.getJavaClass(), (Object)1);
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)a._persistence_getPropertyChangeListener());
        DynamicEntityImpl c = (DynamicEntityImpl)a.get("c");
        Assert.assertNotNull((Object)c);
        Assert.assertNotNull((Object)c._persistence_getPropertyChangeListener());
        Assert.assertTrue((boolean)(c._persistence_getPropertyChangeListener() instanceof AggregateAttributeChangeListener));
        em.getTransaction().rollback();
        em.close();
    }

    @Test
    public void createSimpleAwithSimpleB() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = helper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        EntityManager em = emf.createEntityManager();
        Assert.assertNotNull((Object)helper.getSession().getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("value2", (Object)true);
        simpleInstanceB.set("value3", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)2);
        simpleInstanceA.set("value1", (Object)"A2");
        simpleInstanceA.set("b", (Object)simpleInstanceB);
        em.getTransaction().begin();
        em.persist((Object)simpleInstanceA);
        em.getTransaction().commit();
        int simpleCountA = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCountA);
        em.close();
    }
}

