/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractValidatingDialog
extends AbstractDialog {
    private JLabel errorMessageLabel;
    private JLabel warningMessageLabel;
    JLabel accessibleLabel;

    protected AbstractValidatingDialog(WorkbenchContext context) {
        super(context);
    }

    protected AbstractValidatingDialog(WorkbenchContext context, String title) {
        super(context, title);
    }

    protected AbstractValidatingDialog(WorkbenchContext context, String title, Dialog owner) {
        super(context, title, owner);
    }

    @Override
    protected void initializeContentPane() {
        this.container.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.container.setOpaque(false);
        contentPane.add((Component)this.container, "Center");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.container.add(this.buildMainPanel(), constraints);
        this.errorMessageLabel = this.buildErrorMessageLabel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.container.add((Component)this.errorMessageLabel, constraints);
        this.warningMessageLabel = this.buildWarningMessageLabel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.container.add((Component)this.warningMessageLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 5, 10, 5);
        this.container.add((Component)new JSeparator(), constraints);
        JPanel buttonPanel = this.buildButtonPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)buttonPanel, constraints);
        StatusBarPane statusBarPane = new StatusBarPane();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)statusBarPane, constraints);
    }

    @Override
    protected void windowOpened() {
        super.windowOpened();
        if (StringTools.stringIsEmpty((String)this.errorMessageLabel.getText())) {
            this.errorMessageLabel.setVisible(false);
        }
        if (this.errorMessageLabel.isVisible() || StringTools.stringIsEmpty((String)this.warningMessageLabel.getText())) {
            this.warningMessageLabel.setVisible(false);
        }
    }

    protected JLabel buildErrorMessageLabel() {
        JLabel label = new JLabel();
        label.setIcon(this.resourceRepository().getIcon("error"));
        label.setPreferredSize(new Dimension(300, 16));
        return label;
    }

    protected void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    protected JLabel getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected void setErrorMessage(String message) {
        boolean visible;
        this.errorMessageLabel.setText(message);
        boolean bl = visible = !StringTools.stringIsEmpty((String)message);
        if (this.errorMessageLabel.isVisible() != visible && this.isVisible()) {
            this.errorMessageLabel.setVisible(visible);
        }
        if (this.errorMessageLabel.isVisible() && this.warningMessageLabel.isVisible()) {
            this.warningMessageLabel.setVisible(false);
        }
        this.updateAccessibleMessage(message);
    }

    protected void setErrorMessageKey(String key) {
        this.setErrorMessage(this.resourceRepository().getString(key));
    }

    protected void setErrorMessageKey(String key, Object argument) {
        this.setErrorMessage(this.resourceRepository().getString(key, argument));
    }

    protected JLabel buildWarningMessageLabel() {
        JLabel label = new JLabel();
        label.setIcon(this.resourceRepository().getIcon("warning"));
        label.setPreferredSize(new Dimension(300, 16));
        return label;
    }

    protected void clearWarningMessage() {
        this.setWarningMessage(null);
    }

    protected JLabel getWarningMessageLabel() {
        return this.warningMessageLabel;
    }

    protected void setWarningMessage(String message) {
        boolean visible;
        this.warningMessageLabel.setText(message);
        boolean bl = visible = !StringTools.stringIsEmpty((String)message) && !this.errorMessageLabel.isVisible();
        if (this.warningMessageLabel.isVisible() != visible && this.isVisible()) {
            this.warningMessageLabel.setVisible(visible);
        }
        this.updateAccessibleMessage(message);
    }

    protected void setWarningMessageKey(String key) {
        this.setWarningMessage(this.resourceRepository().getString(key));
    }

    protected void setWarningMessageKey(String key, Object argument) {
        this.setWarningMessage(this.resourceRepository().getString(key, argument));
    }

    protected void updateAccessibleMessage(String message) {
        if (this.accessibleLabel != null) {
            this.accessibleLabel.setText(message);
        }
    }

    private class StatusBarPane
    extends JPanel {
        public StatusBarPane() {
            super(new BorderLayout());
        }

        private void buildStatusBar() {
            AbstractValidatingDialog.this.accessibleLabel = new AccessibleLabel();
            AbstractValidatingDialog.this.accessibleLabel.setVisible(false);
            StatusBar statusBar = new StatusBar();
            statusBar.setVisible(false);
            statusBar.add(AbstractValidatingDialog.this.accessibleLabel);
            this.add((Component)statusBar, "Center");
            this.validate();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarPane();
                this.buildStatusBar();
            }
            return this.accessibleContext;
        }

        private class StatusBar
        extends JPanel {
            private StatusBar() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleStatusBar();
                }
                return this.accessibleContext;
            }

            protected class AccessibleStatusBar
            extends JPanel.AccessibleJPanel {
                protected AccessibleStatusBar() {
                    super(StatusBar.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.STATUS_BAR;
                }
            }
        }

        private class AccessibleLabel
        extends JLabel {
            private AccessibleLabel() {
            }

            @Override
            public void setText(String text) {
                String oldText = this.getText();
                super.setText(text);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", oldText, text);
                }
            }
        }

        protected class AccessibleStatusBarPane
        extends JPanel.AccessibleJPanel {
            protected AccessibleStatusBarPane() {
                super(StatusBarPane.this);
            }
        }
    }
}

