/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicyInsertFieldReturnOnlyFlag;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class ReturningInsertFieldsPanel
extends AbstractSubjectPanel {
    private TableModel tableModel;
    private ListValueModel sortedFieldsAdapter;
    private ObjectListSelectionModel rowSelectionModel;
    private Action removeAction;

    protected ReturningInsertFieldsPanel(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)subjectHolder, contextHolder);
    }

    @Override
    protected void initializeLayout() {
        this.sortedFieldsAdapter = this.buildSortedInsertFieldReturnOnlyFlagsAdapter();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel buttonPanel = this.buildButtonPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 22;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)buttonPanel, constraints);
        JComponent insertTablePane = this.buildInsertPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)insertTablePane, constraints);
    }

    private JComponent buildInsertPanel() {
        JTable table = this.buildTable();
        JScrollPane insertTablePane = new JScrollPane(table);
        insertTablePane.getViewport().setBackground(table.getBackground());
        return insertTablePane;
    }

    private JTable buildTable() {
        JTable table = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        int rowHeight = 20;
        TableColumn column = table.getColumnModel().getColumn(0);
        TableCellRenderer fieldRenderer = this.buildFieldColumnCellRenderer();
        column.setCellRenderer(fieldRenderer);
        column = table.getColumnModel().getColumn(1);
        CheckBoxTableCellRenderer returnOnlyRenderer = new CheckBoxTableCellRenderer();
        column.setCellRenderer(returnOnlyRenderer);
        column.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        rowHeight = Math.max(rowHeight, returnOnlyRenderer.getPreferredHeight());
        table.setRowHeight(rowHeight);
        return table;
    }

    protected TableCellRenderer buildFieldColumnCellRenderer() {
        return new SimpleTableCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? null : ((MWDataField)value).fieldName();
            }
        };
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedFieldsAdapter));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        rowSelectionModel.setSelectionMode(2);
        return rowSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ReturningInsertFieldsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object[] selection = this.rowSelectionModel.getSelectedValues();
        boolean fieldSelected = selection.length > 0;
        this.removeAction.setEnabled(fieldSelected);
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedFieldsAdapter, this.buildInsertColumnAdapter());
    }

    private ColumnAdapter buildInsertColumnAdapter() {
        return new InsertFieldColumnAdapter(this.resourceRepository());
    }

    private ListValueModel buildSortedInsertFieldReturnOnlyFlagsAdapter() {
        return new SortedListValueModelAdapter(this.buildColumnNameAdapter());
    }

    private ListValueModel buildColumnNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildInsertFieldReturnOnlyFlagsAdapter(), "name");
    }

    private CollectionValueModel buildInsertFieldReturnOnlyFlagsAdapter() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "insertFieldReturnOnlyFlags"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWReturningPolicy)this.subject).insertFieldReturnOnlyFlags();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWReturningPolicy)this.subject).insertFieldReturnOnlyFlagsSize();
            }
        };
    }

    protected MWReturningPolicy returningPolicy() {
        return (MWReturningPolicy)this.getSubjectHolder().getValue();
    }

    private JPanel buildButtonPanel() {
        AccessibleTitledPanel buttonPanel = new AccessibleTitledPanel(new GridLayout(1, 0, 5, 0));
        buttonPanel.add(this.buildAddButton());
        buttonPanel.add(this.buildRemoveButton());
        return buttonPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        final AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.initializeText("ADD_BUTTON");
                this.initializeMnemonic("ADD_BUTTON");
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ReturningInsertFieldsPanel.this.addField();
            }
        };
        action.setEnabled(true);
        this.getSubjectHolder().addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                action.setEnabled(ReturningInsertFieldsPanel.this.returningPolicy() != null);
            }
        });
        return action;
    }

    protected abstract void addField();

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.initializeText("REMOVE_BUTTON");
                this.initializeMnemonic("REMOVE_BUTTON");
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ReturningInsertFieldsPanel.this.removeField();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeField() {
        Object[] selectedFields = this.selectedFields();
        int index = selectedFields.length;
        while (--index >= 0) {
            this.returningPolicy().removeInsertFieldReturnOnlyFlag((MWReturningPolicyInsertFieldReturnOnlyFlag)selectedFields[index]);
        }
    }

    private Object[] selectedFields() {
        return this.rowSelectionModel.getSelectedValues();
    }

    private static class InsertFieldColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int INSERT_FIELD_COLUMN = 0;
        public static final int RETURN_ONLY_COLUMN = 1;
        private final String[] COLUMN_NAME_KEYS = new String[]{"RETURNING_POLICY_INSERT_COLUMN_HEADER", "RETURNING_POLICY_RETURN_ONLY_COLUMN_HEADER"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        protected InsertFieldColumnAdapter(ResourceRepository repository) {
            this.resourceRepository = repository;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[index]);
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isColumnEditable(int index) {
            switch (index) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWReturningPolicyInsertFieldReturnOnlyFlag insert = (MWReturningPolicyInsertFieldReturnOnlyFlag)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildInsertFieldAdapter(insert), this.buildReturnOnlyAdapter(insert)};
            return result;
        }

        private PropertyValueModel buildInsertFieldAdapter(MWReturningPolicyInsertFieldReturnOnlyFlag field) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)field){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWReturningPolicyInsertFieldReturnOnlyFlag)this.subject).getField();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "fieldName");
        }

        private PropertyValueModel buildReturnOnlyAdapter(MWReturningPolicyInsertFieldReturnOnlyFlag field) {
            return new PropertyAspectAdapter("returnOnly", (Model)field){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWReturningPolicyInsertFieldReturnOnlyFlag)this.subject).isReturnOnly();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWReturningPolicyInsertFieldReturnOnlyFlag)this.subject).setReturnOnly(((Boolean)value).booleanValue());
                }
            };
        }
    }
}

