/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DateSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class ProjectCacheExpiryPanel
extends AbstractSubjectPanel {
    ProjectCacheExpiryPanel(ApplicationContext context, PropertyValueModel cachingExpiryHolder) {
        super((ValueModel)cachingExpiryHolder, context.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class));
    }

    private PropertyValueModel buildCacheExpiryTypHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "expiryType"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getExpiryType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setExpiryType((String)value);
            }
        };
    }

    private void buildDailyExpiryComponentEnabler(Component component) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(this.buildCacheExpiryTypHolder()){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return "Daily Expiry".equals(value);
            }
        };
        new ComponentEnabler((ValueModel)booleanHolder, component);
    }

    private PropertyValueModel buildDailyExpiryHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "dailyExpiryTime"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getDailyExpiryTime();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setDailyExpiryTime((Date)value);
            }
        };
    }

    private ButtonModel buildDailyExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.buildCacheExpiryTypHolder(), "Daily Expiry");
    }

    private SpinnerDateModel buildDailyExpirySpinnerAdapter() {
        Date MIN = new Date(0, 0, 1, 0, 0, 0);
        Date MAX = new Date(300, 0, 1, 0, 0, 0);
        return new DateSpinnerModelAdapter(this.buildDailyExpiryHolder(), MIN, MAX, 12, MIN);
    }

    private ButtonModel buildNoCacheExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.buildCacheExpiryTypHolder(), "No Expiry");
    }

    private ComponentEnabler buildTimeToLiveExpiryComponentEnabler(Component component) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(this.buildCacheExpiryTypHolder()){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return "Time to Live Expiry".equals(value);
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, component);
    }

    private PropertyValueModel buildTimeToLiveExpiryHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "timeToLiveExpiry"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getTimeToLiveExpiry();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setTimeToLiveExpiry((Long)value);
            }
        };
    }

    private ButtonModel buildTimeToLiveExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.buildCacheExpiryTypHolder(), "Time to Live Expiry");
    }

    private SpinnerNumberModel buildTimeToLiveExpirySpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildTimeToLiveExpiryHolder(), new Long(0L), new Long(Long.MAX_VALUE), new Long(1L), new Long(0L));
    }

    private ButtonModel buildUpdateReadTimeOnUpdateCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUpdateReadTimeOnUpdateHolder());
    }

    private ComponentEnabler buildUpdateReadTimeOnUpdateComponentEnabler(Component component) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(this.buildCacheExpiryTypHolder()){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return !"No Expiry".equals(value);
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, component);
    }

    private PropertyValueModel buildUpdateReadTimeOnUpdateHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "updateReadTimeOnUpdate"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getUpdateReadTimeOnUpdate();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWCacheExpiry)this.subject).setUpdateReadTimeOnUpdate(((Boolean)value).booleanValue());
            }
        };
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("CACHING_POLICY_CACHE_EXPIRY"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JRadioButton noCacheExpiryButton = this.buildRadioButton("CACHING_POLICY_NO_EXPIRY", this.buildNoCacheExpiryRadioButtonAdapter());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)noCacheExpiryButton, constraints);
        JRadioButton timeToLiveExpiryButton = this.buildRadioButton("CACHING_POLICY_TIME_TO_LIVE_EXPIRY", this.buildTimeToLiveExpiryRadioButtonAdapter());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)timeToLiveExpiryButton, constraints);
        JLabel expireAfterLabel = this.buildLabel("CACHING_POLICY_TIME_TO_LIVE_EXPIRY_PREFIX_LABEL");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)expireAfterLabel, constraints);
        JSpinner timeToLiveExpirySpinner = SwingComponentFactory.buildSpinnerNumber(this.buildTimeToLiveExpirySpinnerAdapter());
        SwingComponentFactory.attachDateSpinnerCommiter(timeToLiveExpirySpinner, this.getSubjectHolder());
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)timeToLiveExpirySpinner, constraints);
        expireAfterLabel.setLabelFor(timeToLiveExpirySpinner);
        this.buildTimeToLiveExpiryComponentEnabler(timeToLiveExpirySpinner);
        JLabel millisecondsLabel = this.buildLabel("CACHING_POLICY_TIME_TO_LIVE_EXPIRY_POSTFIX_LABEL");
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)millisecondsLabel, constraints);
        JRadioButton dailyExpiryButton = this.buildRadioButton("CACHING_POLICY_DAILY_EXPIRY", this.buildDailyExpiryRadioButtonAdapter());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)dailyExpiryButton, constraints);
        millisecondsLabel.setLabelFor(dailyExpiryButton);
        JLabel expireAtLabel = this.buildLabel("CACHING_POLICY_DAILY_EXPIRY_PREFIX_LABEL");
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)expireAtLabel, constraints);
        JSpinner dailyExpirySpinner = this.buildSpinnerDate(this.buildDailyExpirySpinnerAdapter());
        dailyExpirySpinner.setEditor(new JSpinner.DateEditor(dailyExpirySpinner, "HH : mm : ss"));
        SwingComponentFactory.attachDateSpinnerCommiter(dailyExpirySpinner, this.getSubjectHolder());
        int width = SwingUtilities.computeStringWidth(dailyExpirySpinner.getFontMetrics(dailyExpirySpinner.getFont()), "00 : 00 : 00");
        dailyExpirySpinner.setPreferredSize(new Dimension(width + 10, dailyExpirySpinner.getPreferredSize().height));
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)dailyExpirySpinner, constraints);
        expireAtLabel.setLabelFor(dailyExpirySpinner);
        this.buildDailyExpiryComponentEnabler(dailyExpirySpinner);
        JCheckBox updateReadTimeOnUpdateCheckBox = this.buildCheckBox("CACHING_POLICY_UPDATE_READ_TIME_ON_UPDATE", this.buildUpdateReadTimeOnUpdateCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 5, 0);
        this.add((Component)updateReadTimeOnUpdateCheckBox, constraints);
        this.buildUpdateReadTimeOnUpdateComponentEnabler(updateReadTimeOnUpdateCheckBox);
    }
}

