/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ZeroArgConstructorPreference {
    public static final String MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_PREFERENCE = "mantain zero argument constructor";
    public static final String YES = "true";
    public static final String NO = "false";
    public static final String PROMPT = "prompt";
    public static final String DEFAULT = "prompt";

    private ZeroArgConstructorPreference() {
    }

    public static void optionallyAddZeroArgumentConstructor(MWClass mwClass, WorkbenchContext context) {
        String maintainZeroArgCon = context.getApplicationContext().getPreferences().get(MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_PREFERENCE, "prompt").intern();
        if (maintainZeroArgCon == YES || maintainZeroArgCon == "prompt" && ZeroArgConstructorPreference.promptForResponse(mwClass, context)) {
            mwClass.addZeroArgumentConstructor();
        }
    }

    private static boolean promptForResponse(MWClass mwClass, WorkbenchContext context) {
        Preferences preferences = context.getApplicationContext().getPreferences();
        ResourceRepository resourceRepository = context.getApplicationContext().getResourceRepository();
        String title = resourceRepository.getString("PREFERENCES.MAPPINGS.CLASS.MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_DIALOG.title");
        String message = resourceRepository.getString("PREFERENCES.MAPPINGS.CLASS.MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_DIALOG.message", new Object[]{mwClass.getName(), StringTools.CR});
        SimplePropertyValueModel dontAskAgainHolder = new SimplePropertyValueModel(new Boolean(false));
        JComponent dontAskAgainPanel = SwingComponentFactory.buildDoNotAskAgainPanel(message, dontAskAgainHolder, resourceRepository);
        int response = JOptionPane.showConfirmDialog(context.getCurrentWindow(), dontAskAgainPanel, title, 0, 3);
        if (dontAskAgainHolder.getValue().equals(Boolean.TRUE)) {
            String preference = "prompt";
            if (response == 0) {
                preference = YES;
            } else if (response == 1) {
                preference = NO;
            }
            preferences.put(MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_PREFERENCE, preference);
        }
        return response == 0;
    }
}

