/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectXMLAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionMultipleProjectsPane;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class XmlSessionMultipleProjectsPane
extends AbstractSessionMultipleProjectsPane {
    XmlSessionMultipleProjectsPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    @Override
    protected void addProject(ObjectListSelectionModel selectionModel) {
        DatabaseSessionAdapter databaseSession = (DatabaseSessionAdapter)this.subject();
        SimplePropertyValueModel projectXmlHolder = new SimplePropertyValueModel();
        ProjectXmlEditDialog dialog = new ProjectXmlEditDialog(projectXmlHolder);
        dialog.setVisible(true);
        if (dialog.wasCanceled()) {
            return;
        }
        String projectXml = (String)projectXmlHolder.getValue();
        String temporaryProjectXml = projectXml.replace('\\', '/');
        if (CollectionTools.contains((Iterator)databaseSession.additionalProjectNames(), (Object)temporaryProjectXml)) {
            ProjectAdapter project = databaseSession.projectNamed(temporaryProjectXml);
            selectionModel.setSelectedValue((Object)project);
        } else {
            ProjectXMLAdapter project = databaseSession.addProjectXmlNamed(projectXml);
            selectionModel.setSelectedValue((Object)project);
        }
    }

    private File retrieveLastDirectory() {
        DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject();
        TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)session.getParent();
        File saveDirectory = topLinkSessions.getSaveDirectory();
        if (saveDirectory == null) {
            saveDirectory = FileTools.userHomeDirectory();
        }
        return new File(this.preferences().get("location", saveDirectory.getPath()));
    }

    private class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || ".xml".equalsIgnoreCase(FileTools.extension((File)file));
        }

        @Override
        public String getDescription() {
            return XmlSessionMultipleProjectsPane.this.resourceRepository().getString("SESSION_PROJECT_ADVANCED_FILE_CHOOSER_DESCRIPTION");
        }
    }

    private class ProjectXmlEditDialog
    extends AbstractValidatingDialog {
        private final PropertyValueModel projectXmlHolder;
        private JTextField textField;

        ProjectXmlEditDialog(PropertyValueModel projectXmlHolder) {
            super(XmlSessionMultipleProjectsPane.this.getWorkbenchContext(), XmlSessionMultipleProjectsPane.this.resourceRepository().getString("PROJECT_TYPE_EDIT_DIALOG_TITLE_ADD"));
            this.projectXmlHolder = projectXmlHolder;
            projectXmlHolder.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        }

        private void addProjectXML() {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new XmlFileFilter());
            fileChooser.setCurrentDirectory(XmlSessionMultipleProjectsPane.this.retrieveLastDirectory());
            fileChooser.setFileSelectionMode(0);
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.preferences().put("location", selectedFile.getParent());
                String projectXml = selectedFile.getAbsolutePath();
                this.projectXmlHolder.setValue(projectXml);
            }
        }

        @Override
        protected Component buildMainPanel() {
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel container = new JPanel(new GridBagLayout());
            JButton xmlBrowseButton = SwingComponentFactory.buildButton("PROJECT_TYPE_EDIT_DIALOG_XML_BROWSE_BUTTON", this.resourceRepository());
            xmlBrowseButton.addActionListener(this.buildXMLBrowseAction());
            this.textField = new JTextField(this.buildProjectXmlDocumentAdapter(), null, 30);
            JComponent ProjectXmlWidgets = this.buildLabeledComponent("PROJECT_TYPE_EDIT_DIALOG_XML_FIELD", (JComponent)this.textField, (JComponent)xmlBrowseButton);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            container.add((Component)ProjectXmlWidgets, constraints);
            return container;
        }

        private Document buildProjectXmlDocumentAdapter() {
            return new DocumentAdapter(this.projectXmlHolder);
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String projectXml = (String)e.getNewValue();
                    boolean valid = !StringTools.stringIsEmpty((String)projectXml);
                    ProjectXmlEditDialog.this.getOKAction().setEnabled(valid);
                    if (valid) {
                        ProjectXmlEditDialog.this.clearErrorMessage();
                    } else {
                        ProjectXmlEditDialog.this.setErrorMessageKey("PROJECT_TYPE_EDIT_DIALOG_ERROR_MESSAGE");
                    }
                }
            };
        }

        private ActionListener buildXMLBrowseAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectXmlEditDialog.this.addProjectXML();
                }
            };
        }

        @Override
        protected String helpTopicId() {
            return "dialog.session.projectType";
        }

        @Override
        protected Component initialFocusComponent() {
            return this.textField;
        }

        @Override
        protected void prepareToShow() {
            super.prepareToShow();
            this.getOKAction().setEnabled(false);
        }
    }
}

