/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

public abstract class AspectAdapter
extends AbstractModel
implements ValueModel {
    protected Object subject;
    protected ValueModel subjectHolder;
    protected PropertyChangeListener subjectChangeListener;

    protected AspectAdapter(Object subject) {
        this(new ReadOnlyPropertyValueModel(subject));
    }

    protected AspectAdapter(ValueModel subjectHolder) {
        if (subjectHolder == null) {
            throw new NullPointerException();
        }
        this.subjectHolder = subjectHolder;
        this.subject = null;
    }

    protected void initialize() {
        super.initialize();
        this.subjectChangeListener = this.buildSubjectChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AspectAdapter.this.subjectChanged();
            }

            public String toString() {
                return "subject change listener";
            }
        };
    }

    protected synchronized void subjectChanged() {
        Object oldValue = this.getValue();
        boolean hasListeners = this.hasListeners();
        if (hasListeners) {
            this.disengageSubject();
        }
        this.subject = this.subjectHolder.getValue();
        if (hasListeners) {
            this.engageSubject();
            this.fireAspectChange(oldValue, this.getValue());
        }
    }

    protected abstract boolean hasListeners();

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected abstract void fireAspectChange(Object var1, Object var2);

    protected abstract void engageNonNullSubject();

    protected void engageSubject() {
        if (this.subject != null) {
            this.engageNonNullSubject();
        }
    }

    protected abstract void disengageNonNullSubject();

    protected void disengageSubject() {
        if (this.subject != null) {
            this.disengageNonNullSubject();
        }
    }

    protected void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.subject = this.subjectHolder.getValue();
    }

    protected void disengageSubjectHolder() {
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        this.subject = null;
    }

    protected void engageModels() {
        this.engageSubjectHolder();
        this.engageSubject();
    }

    protected void disengageModels() {
        this.disengageSubject();
        this.disengageSubjectHolder();
    }

    public synchronized void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addStateChangeListener(listener);
    }

    public synchronized void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (propertyName == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addCollectionChangeListener(listener);
    }

    public synchronized void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public synchronized void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addListChangeListener(listener);
    }

    public synchronized void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addListChangeListener(listName, listener);
    }

    public synchronized void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addTreeChangeListener(TreeChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addTreeChangeListener(listener);
    }

    public synchronized void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        if (treeName == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addTreeChangeListener(treeName, listener);
    }

    public synchronized void removeTreeChangeListener(TreeChangeListener listener) {
        super.removeTreeChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        super.removeTreeChangeListener(treeName, listener);
        if (treeName == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }
}

