/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.uitools.app.NullPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;

public abstract class IndirectComboBoxModel
extends AbstractListModel
implements CachingComboBoxModel {
    private PropertyValueModel selectedItemHolder;
    private PropertyChangeListener selectedItemListener;
    private ValueModel listSubjectHolder;
    private PropertyChangeListener listSubjectListener;
    private int cachedSize;
    private List cachedList;

    public IndirectComboBoxModel(PropertyValueModel selectedItemHolder) {
        this(selectedItemHolder, NullPropertyValueModel.instance());
    }

    public IndirectComboBoxModel(PropertyValueModel selectedItemHolder, ValueModel listSubjectHolder) {
        if (selectedItemHolder == null || listSubjectHolder == null) {
            throw new NullPointerException();
        }
        this.selectedItemHolder = selectedItemHolder;
        this.selectedItemListener = this.buildSelectedItemListener();
        this.listSubjectHolder = listSubjectHolder;
        this.listSubjectListener = this.buildListSubjectListener();
    }

    protected PropertyChangeListener buildSelectedItemListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndirectComboBoxModel.this.fireSelectedItemChanged();
            }

            public String toString() {
                return "selected item listener";
            }
        };
    }

    protected PropertyChangeListener buildListSubjectListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndirectComboBoxModel.this.fireContentsChanged();
            }

            public String toString() {
                return "list subject listener";
            }
        };
    }

    @Override
    public void setSelectedItem(Object newSelectedItem) {
        this.selectedItemHolder.setValue(newSelectedItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItemHolder.getValue();
    }

    @Override
    public int getSize() {
        int size;
        int n = size = this.listSubjectHolder.getValue() == null ? 0 : this.listSizeFromSubject(this.listSubjectHolder.getValue());
        if (this.cachedSize != size) {
            this.cachedSize = size;
            this.fireContentsChanged();
        }
        return size;
    }

    protected int listSizeFromSubject(Object listSubject) {
        return CollectionTools.size((Iterator)this.listValue());
    }

    @Override
    public Object getElementAt(int index) {
        return CollectionTools.get((ListIterator)this.listValue(), (int)index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.hasNoListDataListeners()) {
            this.engageModel();
        }
        super.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        super.removeListDataListener(l);
        if (this.hasNoListDataListeners()) {
            this.disengageModel();
        }
    }

    protected void fireSelectedItemChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    protected void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.cachedSize - 1);
    }

    protected ListIterator listValue() {
        if (this.cachedList != null) {
            return this.cachedList.listIterator();
        }
        Object listSubject = this.listSubjectHolder.getValue();
        if (listSubject == null) {
            return NullListIterator.instance();
        }
        return this.listValueFromSubject(listSubject);
    }

    protected ListIterator listValueFromSubject(Object subject) {
        return NullListIterator.instance();
    }

    protected boolean hasNoListDataListeners() {
        return this.getListDataListeners().length == 0;
    }

    protected boolean hasListDataListeners() {
        return !this.hasNoListDataListeners();
    }

    protected void engageModel() {
        this.selectedItemHolder.addPropertyChangeListener("value", this.selectedItemListener);
        this.listSubjectHolder.addPropertyChangeListener("value", this.listSubjectListener);
    }

    protected void disengageModel() {
        this.listSubjectHolder.removePropertyChangeListener("value", this.listSubjectListener);
        this.selectedItemHolder.removePropertyChangeListener("value", this.selectedItemListener);
    }

    @Override
    public void cacheList() {
        if (this.isCached()) {
            throw new IllegalArgumentException("List is already Cached, see isCached()");
        }
        this.cachedList = CollectionTools.list((Iterator)this.listValue());
    }

    @Override
    public void uncacheList() {
        if (!this.isCached()) {
            throw new IllegalArgumentException("List is not cached");
        }
        this.cachedList = null;
    }

    @Override
    public boolean isCached() {
        return this.cachedList != null;
    }
}

