/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

public class FilteringIterator
implements Iterator {
    private Iterator nestedIterator;
    private Filter filter;
    private Object next;
    private static final Object START = new Object();
    private static final Object END = new Object();

    public FilteringIterator(Iterator nestedIterator) {
        this(nestedIterator, Filter.NULL_INSTANCE);
    }

    public FilteringIterator(Iterator nestedIterator, Filter filter) {
        this.nestedIterator = nestedIterator;
        this.filter = filter;
        this.next = START;
    }

    @Override
    public boolean hasNext() {
        if (this.next == START) {
            this.loadNext();
        }
        return this.next != END;
    }

    public Object next() {
        if (this.next == START) {
            this.loadNext();
        }
        if (this.next == END) {
            throw new NoSuchElementException();
        }
        Object result = this.next;
        this.loadNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        this.next = END;
        while (this.nestedIterator.hasNext() && this.next == END) {
            this.next = this.nestedIterator.next();
            if (this.accept(this.next)) continue;
            this.next = END;
        }
    }

    protected boolean accept(Object o) {
        return this.filter.accept(o);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.nestedIterator + ')';
    }
}

