/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TableDDLTestSuite {
    static final String SIMPLETABLE = "DTB_SIMPLETABLE";
    static final String SIMPLETABLE_FIELD1 = "ID";
    static final String SIMPLETABLE_FIELD2 = "NAME";
    static final String SIMPLETABLE_FIELD3 = "SINCE";
    static final String CREATE_SIMPLETABLE = "CREATE TABLE DTB_SIMPLETABLE (\nID INTEGER NOT NULL,\nNAME VARCHAR2(25),\nSINCE DATE,\nPRIMARY KEY (ID,NAME)\n)";
    static final String DROP_SIMPLETABLE = "DROP TABLE DTB_SIMPLETABLE";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static TableType tableType = null;
    static List<String> expectedFieldNames = new ArrayList<String>();
    static List<String> expectedPKFieldNames = new ArrayList<String>();
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws SQLException, ClassNotFoundException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_SIMPLETABLE, ddlDebug);
        }
        boolean worked = true;
        String msg = null;
        try {
            String schema = System.getProperty("db.user", "scott");
            tableType = dtBuilder.buildTables(conn, schema, SIMPLETABLE).get(0);
        }
        catch (Exception e) {
            worked = false;
            msg = e.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
        expectedPKFieldNames.add(SIMPLETABLE_FIELD1);
        expectedPKFieldNames.add(SIMPLETABLE_FIELD2);
        expectedFieldNames.add(SIMPLETABLE_FIELD1);
        expectedFieldNames.add(SIMPLETABLE_FIELD2);
        expectedFieldNames.add(SIMPLETABLE_FIELD3);
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_SIMPLETABLE, ddlDebug);
        }
    }

    @Test
    public void testTableName() {
        Assert.assertEquals((String)"incorrect table name", (Object)SIMPLETABLE, (Object)tableType.getTableName());
    }

    @Test
    public void testNumberOfColumns() {
        List<FieldType> columns = tableType.getColumns();
        Assert.assertTrue((String)"incorrect number of columns", (columns.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testPrimaryKeys() {
        List<FieldType> columns = tableType.getColumns();
        ArrayList<String> pkFieldNames = new ArrayList<String>();
        for (FieldType field : columns) {
            if (!field.pk()) continue;
            pkFieldNames.add(field.getFieldName());
        }
        Assert.assertEquals((String)"incorrect PK column names", expectedPKFieldNames, pkFieldNames);
    }

    @Test
    public void testColumnNames() {
        List<FieldType> columns = tableType.getColumns();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldType field : columns) {
            fieldNames.add(field.getFieldName());
        }
        Assert.assertEquals((String)"incorrect column names", expectedFieldNames, fieldNames);
    }

    @Test
    public void testColumnTypes() {
        List<FieldType> columns = tableType.getColumns();
        FieldType field1 = columns.get(0);
        DatabaseType col1Type = field1.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [ID]", (Object)ScalarDatabaseTypeEnum.INTEGER_TYPE.getTypeName(), (Object)col1Type.getTypeName());
        Assert.assertTrue((String)"incorrect NULL constraint for column [ID]", (boolean)field1.notNull());
        FieldType field2 = columns.get(1);
        DatabaseType col2Type = field2.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [NAME]", (Object)new VarChar2Type().getTypeName(), (Object)col2Type.getTypeName());
        Assert.assertFalse((String)"incorrect NULL constraint for column [NAME]", (boolean)field2.notNull());
        Assert.assertTrue((String)"incorrect size for column [NAME]", (((SizedType)col2Type).getSize() == 25L ? 1 : 0) != 0);
        FieldType field3 = columns.get(2);
        DatabaseType col3Type = field3.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [SINCE]", (Object)ScalarDatabaseTypeEnum.DATE_TYPE.getTypeName(), (Object)col3Type.getTypeName());
        Assert.assertFalse((String)"incorrect NULL constraint for column [SINCE]", (boolean)field3.notNull());
    }
}

