/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;

public class ArrayIterator<E>
implements Iterator<E> {
    final E[] array;
    int cursor;
    private final int max;

    public ArrayIterator(E ... array) {
        this(array, 0);
    }

    public ArrayIterator(E[] array, int start) {
        this(array, start, array.length);
    }

    public ArrayIterator(E[] array, int start, int end) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("end: " + start);
        }
        if (end < start || end > array.length) {
            throw new IllegalArgumentException("length: " + end);
        }
        this.array = array;
        this.cursor = start;
        this.max = end;
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.max;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.array[this.cursor++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, Arrays.toString(this.array));
    }
}

