/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.Queue;
import org.eclipse.persistence.tools.utility.tests.MultiThreadedTestCase;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public abstract class QueueTests
extends MultiThreadedTestCase {
    public QueueTests(String name) {
        super(name);
    }

    abstract Queue<String> buildQueue();

    public void testIsEmpty() {
        Queue<String> queue = this.buildQueue();
        QueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        QueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        QueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        QueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        QueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueAndDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        QueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
    }

    public void testEnqueueAndPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        QueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
    }

    public void testEmptyQueueExceptionPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        QueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            queue.peek();
            QueueTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        QueueTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        QueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        QueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        QueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            queue.dequeue();
            QueueTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        QueueTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        Queue<String> queue = this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        Queue clone = (Queue)ObjectTools.execute(queue, (String)"clone");
        this.verifyClone(queue, (Queue<String>)clone);
    }

    public void testSerialization() throws Exception {
        Queue<String> queue = this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone(queue, TestTools.serialize(queue));
    }

    private void verifyClone(Queue<String> original, Queue<String> clone) {
        QueueTests.assertNotSame(original, clone);
        QueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        QueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        QueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        QueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        QueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        QueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        QueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        QueueTests.assertTrue((boolean)original.isEmpty());
        QueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"fourth");
        QueueTests.assertFalse((boolean)original.isEmpty());
        QueueTests.assertTrue((boolean)clone.isEmpty());
    }
}

