/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterator.EmptyIterator;

public class EmptyIteratorTests
extends TestCase {
    public EmptyIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator stream = EmptyIterator.instance();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        EmptyIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNext() {
        Iterator stream = EmptyIterator.instance();
        while (stream.hasNext()) {
            EmptyIteratorTests.fail((String)("bogus element: " + (String)stream.next()));
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = EmptyIterator.instance();
        Object element = null;
        while (stream.hasNext()) {
            element = stream.next();
        }
        try {
            element = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        try {
            EmptyIterator.instance().remove();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }
}

